/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.streams.MessageStreams;

public class ProvidenceHelper {
    public static <T extends PMessage<T>, TF extends PField> T fromJsonResource(String path, PStructDescriptor<T, TF> descriptor) throws SerializerException, IOException {
        return ProvidenceHelper.fromResource(path, descriptor, new JsonSerializer(true));
    }

    public static <T extends PMessage<T>, F extends PField> ArrayList<T> arrayListFromJsonResource(String path, PStructDescriptor<T, F> descriptor) throws SerializerException, IOException {
        return ProvidenceHelper.arrayListFromResource(path, descriptor, new JsonSerializer(true));
    }

    public static <T extends PMessage<T>, TF extends PField> T fromResource(String resource, PStructDescriptor<T, TF> descriptor, Serializer serializer) throws SerializerException, IOException {
        InputStream in = ProvidenceHelper.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("No such resource " + resource);
        }
        return serializer.deserialize((InputStream)new BufferedInputStream(in), descriptor);
    }

    public static <T extends PMessage<T>, F extends PField> ArrayList<T> arrayListFromResource(String path, PStructDescriptor<T, F> descriptor, Serializer serializer) throws SerializerException, IOException {
        return (ArrayList)MessageStreams.resource(path, serializer, descriptor).collect(Collectors.toList());
    }

    private ProvidenceHelper() {
    }
}

