/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.io.IOUtils;

public class MessageStreams {
    public static final byte[] READABLE_ENTRY_SEP = new byte[]{10};

    public static <T extends PMessage<T>, F extends PField> Stream<T> file(File file, Serializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return MessageStreams.stream(in, serializer, descriptor);
    }

    public static <T extends PMessage<T>, F extends PField> Stream<T> resource(String resource, Serializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        InputStream in = MessageStreams.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("No such resource " + resource);
        }
        return StreamSupport.stream(new StreamMessageSpliterator(new BufferedInputStream(in), serializer, descriptor, is -> {
            try {
                is.close();
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), false);
    }

    public static <T extends PMessage<T>, F extends PField> Stream<T> stream(InputStream in, Serializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        return StreamSupport.stream(new StreamMessageSpliterator(in, serializer, descriptor, null), false);
    }

    private static class StreamMessageSpliterator<T extends PMessage<T>, F extends PField>
    extends BaseMessageSpliterator<T> {
        private final InputStream in;
        private final PStructDescriptor<T, F> descriptor;
        private final Serializer serializer;
        private int num;
        private Function<InputStream, Void> closer;

        private StreamMessageSpliterator(InputStream in, Serializer serializer, PStructDescriptor<T, F> descriptor, Function<InputStream, Void> closer) throws IOException {
            this.in = in;
            this.closer = closer;
            this.serializer = serializer;
            this.descriptor = descriptor;
            this.num = 0;
        }

        @Override
        public T read() {
            try {
                T out;
                if (this.num > 0 && !this.serializer.binaryProtocol() && !IOUtils.skipUntil((InputStream)this.in, (byte[])READABLE_ENTRY_SEP)) {
                    this.close();
                    T t = null;
                    return t;
                }
                if (this.in.markSupported()) {
                    this.in.mark(2);
                    if (this.in.read() < 0) {
                        T t = null;
                        return t;
                    }
                    this.in.reset();
                }
                if ((out = this.serializer.deserialize(this.in, this.descriptor)) == null) {
                    this.close();
                }
                T t = out;
                return t;
            }
            catch (SerializerException e) {
                throw new UncheckedIOException(new IOException(e));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                ++this.num;
            }
        }

        void close() {
            if (this.closer != null) {
                try {
                    this.closer.apply(this.in);
                }
                finally {
                    this.closer = null;
                }
            }
        }
    }

    private static abstract class BaseMessageSpliterator<T extends PMessage<T>>
    implements Spliterator<T> {
        private BaseMessageSpliterator() {
        }

        protected abstract T read();

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            T message = this.read();
            if (message != null) {
                action.accept(message);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            T message;
            while ((message = this.read()) != null) {
                action.accept(message);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getExactSizeIfKnown() {
            return -1L;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return Comparable::compareTo;
        }
    }
}

