/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.Binary;

public class TypeUtils {
    private static final String NULL = "null";

    public static String toString(double d) {
        long l = (long)d;
        if (d == (double)l) {
            return Long.toString(l);
        }
        if (d > 5119.0 || 1.0 / d > 640.0) {
            return new DecimalFormat("0.#########E0").format(d);
        }
        return Double.toString(d);
    }

    public static String toString(Binary bytes) {
        if (bytes == null) {
            return NULL;
        }
        return String.format("b64(%s)", bytes.toBase64());
    }

    public static String toString(Collection<?> collection) {
        if (collection == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(TypeUtils.toString(item));
        }
        builder.append(']');
        return builder.toString();
    }

    public static String toString(Map<?, ?> map) {
        if (map == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(TypeUtils.toString(entry.getKey())).append(':').append(TypeUtils.toString(entry.getValue()));
        }
        builder.append('}');
        return builder.toString();
    }

    public static String toString(PMessage<?> message) {
        if (message == null) {
            return NULL;
        }
        return message.asString();
    }

    public static String toString(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof Map) {
            return TypeUtils.toString((Map)o);
        }
        if (o instanceof Collection) {
            return TypeUtils.toString((Collection)o);
        }
        if (o instanceof Binary) {
            return TypeUtils.toString((Binary)o);
        }
        if (o instanceof PMessage) {
            return TypeUtils.toString((PMessage)o);
        }
        if (o instanceof Double) {
            return TypeUtils.toString((Double)o);
        }
        return o.toString();
    }

    public static boolean equals(Object v1, Object v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null != (v2 == null)) {
            return false;
        }
        if (v1 instanceof List && v2 instanceof List) {
            List l1 = (List)v1;
            List l2 = (List)v2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (TypeUtils.equals(l1.get(i), l2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (v1 instanceof Set && v2 instanceof Set) {
            Set s1 = (Set)v1;
            Set s2 = (Set)v2;
            if (s1.size() != s2.size()) {
                return false;
            }
            for (Object o : s1) {
                if (s2.contains(o)) continue;
                return false;
            }
            return true;
        }
        if (v1 instanceof Map && v2 instanceof Map) {
            Map m1 = (Map)v1;
            Map m2 = (Map)v2;
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Object key : m1.keySet()) {
                if (TypeUtils.equals(m1.get(key), m2.get(key))) continue;
                return false;
            }
            return true;
        }
        return v1.equals(v2);
    }

    public static int hashCode(PField field, Object object) {
        return TypeUtils.hashCode(field) * TypeUtils.hashCode(object);
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object instanceof List) {
            return TypeUtils.hashCodeList((List)object);
        }
        if (object instanceof Set) {
            return TypeUtils.hashCodeSet((Set)object);
        }
        if (object instanceof Map) {
            return TypeUtils.hashCodeMap((Map)object);
        }
        return object.getClass().hashCode() * object.hashCode();
    }

    public static boolean equalsQualifiedName(PDescriptor a, PDescriptor b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.getQualifiedName(null).equals(b.getQualifiedName(null));
    }

    private static <T> int hashCodeList(List<T> list) {
        int hash = List.class.hashCode();
        int i = 31;
        for (T t : list) {
            hash ^= ++i * t.getClass().hashCode() * TypeUtils.hashCode(t);
        }
        return hash;
    }

    private static <T> int hashCodeSet(Set<T> list) {
        int hash = Set.class.hashCode();
        for (T t : list) {
            hash ^= t.getClass().hashCode() * TypeUtils.hashCode(t);
        }
        return hash;
    }

    private static <K, V> int hashCodeMap(Map<K, V> map) {
        int hash = Map.class.hashCode();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            hash ^= TypeUtils.hashCode(entry.getKey()) * TypeUtils.hashCode(entry.getValue());
        }
        return hash;
    }

    private static <T extends PMessage<T>> int compare(T m1, T m2) {
        int c = 0;
        c = m1.descriptor().getQualifiedName(null).compareTo(m2.descriptor().getQualifiedName(null));
        if (c != 0) {
            return c;
        }
        for (PField field : m1.descriptor().getFields()) {
            c = Boolean.compare(m1.has(field.getKey()), m2.has(field.getKey()));
            if (c != 0) {
                return c;
            }
            if (!m1.has(field.getKey()) || (c = TypeUtils.compare((Comparable)m1.get(field.getKey()), (Comparable)m2.get(field.getKey()))) == 0) continue;
            return c;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return Boolean.compare(o1 != null, o2 != null);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Boolean.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Short && o2 instanceof Short) {
            return Short.compare((Short)o1, (Short)o2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return Integer.compare((Integer)o1, (Integer)o2);
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2);
        }
        if (o1 instanceof Double && o2 instanceof Double) {
            return Double.compare((Double)o1, (Double)o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)((Object)o1)).compareTo((String)((Object)o2));
        }
        if (o1 instanceof Binary && o2 instanceof Binary) {
            return ((Binary)o1).compareTo((Binary)o2);
        }
        if (o1 instanceof PEnumValue && o2 instanceof PEnumValue) {
            return Integer.compare(((PEnumValue)o1).getValue(), ((PEnumValue)o2).getValue());
        }
        if (o1 instanceof PMessage && o2 instanceof PMessage) {
            return TypeUtils.compare((PMessage)o1, (PMessage)o2);
        }
        if (o2 instanceof Map && o2 instanceof Map || o2 instanceof Set && o2 instanceof Set || !(o2 instanceof List) || o2 instanceof List) {
            // empty if block
        }
        return 0;
    }
}

