/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonWriter;

public class PrettyPrinter {
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String SEP = ",";
    private final String mIndent;
    private final String mSpace;
    private final String mNewline;
    private final String mSep;

    public PrettyPrinter() {
        this(INDENT, SPACE, NEWLINE, SEP);
    }

    public PrettyPrinter(String indent, String space, String newline) {
        this(indent, space, newline, SEP);
    }

    public PrettyPrinter(String indent, String space, String newline, String sep) {
        this.mIndent = indent;
        this.mSpace = space;
        this.mNewline = newline;
        this.mSep = sep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(PMessage<?> message) {
        StringWriter stringWriter = new StringWriter();
        try (IndentedPrintWriter builder = new IndentedPrintWriter((Writer)stringWriter, this.mIndent, this.mNewline);){
            this.appendMessage(builder, message);
            builder.flush();
        }
        return stringWriter.toString();
    }

    private void appendMessage(IndentedPrintWriter builder, PMessage<?> message) {
        PStructDescriptor<?, ?> type = message.descriptor();
        builder.append((CharSequence)"{").begin();
        if (message instanceof PUnion) {
            PField field = ((PUnion)message).unionField();
            if (field != null) {
                Object o = message.get(field.getKey());
                builder.appendln((CharSequence)field.getName()).append((CharSequence)":").append((CharSequence)this.mSpace);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        } else {
            boolean first = true;
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append((CharSequence)this.mSep);
                }
                Object o = message.get(field.getKey());
                builder.appendln((CharSequence)field.getName()).append((CharSequence)":").append((CharSequence)this.mSpace);
                this.appendTypedValue(builder, field.getDescriptor(), o);
            }
        }
        builder.end().appendln((CharSequence)"}");
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                writer.append((CharSequence)"[").begin();
                PContainer containerType = (PContainer)descriptor;
                Collection collection = (Collection)o;
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln((CharSequence)"]");
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                writer.append((CharSequence)"{").begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append((CharSequence)":").append((CharSequence)this.mSpace);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln((CharSequence)"}");
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, message);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(o.toString());
        } else if (o instanceof String) {
            JsonWriter jw = new JsonWriter((PrintWriter)writer);
            try {
                jw.value((CharSequence)((String)o));
                jw.flush();
            }
            catch (JsonException jsonException) {}
        } else if (o instanceof Binary) {
            writer.format("b64(%s)", new Object[]{((Binary)o).toBase64()});
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(o.toString());
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d == (double)d.longValue()) {
                writer.print(d.longValue());
            } else if (d > 5119.0 || 1.0 / d > 640.0) {
                writer.print(new DecimalFormat("0.#########E0").format(d));
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }
}

