/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class FastBinarySerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.morimekta.providence.binary";
    protected final boolean readStrict;
    private static final int STOP = 0;
    private static final int NONE = 1;
    private static final int TRUE = 2;
    private static final int VARINT = 3;
    private static final int FIXED_64 = 4;
    private static final int BINARY = 5;
    private static final int MESSAGE = 6;
    private static final int COLLECTION = 7;

    public FastBinarySerializer() {
        this(false);
    }

    public FastBinarySerializer(boolean readStrict) {
        this.readStrict = readStrict;
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream os, T message) throws IOException, SerializerException {
        BinaryWriter out = new BinaryWriter(os);
        return this.writeMessage(out, message);
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream os, PServiceCall<T> call) throws IOException, SerializerException {
        BinaryWriter out = new BinaryWriter(os);
        byte[] method = call.getMethod().getBytes(StandardCharsets.UTF_8);
        int len = out.writeUInt8(method.length);
        len += method.length;
        out.write(method);
        len += out.writeUInt8(call.getType().key);
        len += out.writeInt(call.getSequence());
        return len += this.writeMessage(out, call.getMessage());
    }

    @Override
    public <T extends PMessage<T>, TF extends PField> T deserialize(InputStream is, PStructDescriptor<T, TF> descriptor) throws SerializerException, IOException {
        BinaryReader in = new BinaryReader(is);
        return this.readMessage(in, descriptor);
    }

    @Override
    public <T extends PMessage<T>> PServiceCall<T> deserialize(InputStream is, PService service) throws IOException, SerializerException {
        BinaryReader in = new BinaryReader(is);
        int methodNameLen = in.expectUInt8();
        String methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
        PServiceMethod method = service.getMethod(methodName);
        if (method == null) {
            throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(null), new Object[0]);
        }
        int typeKey = in.expectUInt8();
        PServiceCallType type = PServiceCallType.findByKey(typeKey);
        if (type == null) {
            throw new SerializerException("Invalid call type " + typeKey, new Object[0]);
        }
        int sequence = in.readIntVarint();
        PStructDescriptor descriptor = type.request ? method.getRequestType() : method.getResponseType();
        T message = this.readMessage(in, descriptor);
        return new PServiceCall<T>(methodName, type, sequence, message);
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    private <T extends PMessage<T>> int writeMessage(BinaryWriter out, T message) throws IOException, SerializerException {
        int len = 0;
        if (message instanceof PUnion) {
            PField field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        }
        return len + out.writeVarint(0);
    }

    private <T extends PMessage<T>, TF extends PField> T readMessage(BinaryReader in, PStructDescriptor<T, TF> descriptor) throws SerializerException, IOException {
        int tag;
        PBuilder builder = descriptor.builder();
        while ((tag = in.readIntVarint()) > 0) {
            int id = tag >>> 3;
            int type = tag & 7;
            TF field = descriptor.getField(id);
            if (field != null) {
                T value = this.readFieldValue(in, type, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
                continue;
            }
            if (this.readStrict) {
                throw new SerializerException("Unknown field " + id + " for type" + descriptor.getQualifiedName(null), new Object[0]);
            }
            this.readFieldValue(in, tag, null);
        }
        return (T)((PMessage)builder.build());
    }

    private int writeFieldValue(BinaryWriter out, int key, PDescriptor descriptor, Object value) throws IOException, SerializerException {
        switch (descriptor.getType()) {
            case BOOL: {
                return out.writeVarint(key << 3 | ((Boolean)value != false ? 2 : 1));
            }
            case BYTE: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag((int)((Byte)value).byteValue());
            }
            case I16: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag((int)((Short)value).shortValue());
            }
            case I32: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((Integer)value).intValue());
            }
            case I64: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((Long)value).longValue());
            }
            case DOUBLE: {
                int len = out.writeVarint(key << 3 | 4);
                return len + out.writeDouble(((Double)value).doubleValue());
            }
            case STRING: {
                byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                int len = out.writeVarint(key << 3 | 5);
                out.write(bytes);
                return (len += out.writeVarint(bytes.length)) + bytes.length;
            }
            case BINARY: {
                Binary bytes = (Binary)value;
                int len = out.writeVarint(key << 3 | 5);
                bytes.write((OutputStream)out);
                return (len += out.writeVarint(bytes.length())) + bytes.length();
            }
            case ENUM: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeZigzag(((PEnumValue)value).getValue());
            }
            case MESSAGE: {
                int len = out.writeVarint(key << 3 | 6);
                return len + this.writeMessage(out, (PMessage)value);
            }
            case MAP: {
                int len = out.writeVarint(key << 3 | 7);
                Map map = (Map)value;
                PMap desc = (PMap)descriptor;
                len += out.writeVarint(map.size() * 2);
                for (Map.Entry entry : map.entrySet()) {
                    len += this.writeFieldValue(out, 1, desc.keyDescriptor(), entry.getKey());
                    len += this.writeFieldValue(out, 2, desc.itemDescriptor(), entry.getValue());
                }
                return len;
            }
            case SET: 
            case LIST: {
                int len = out.writeVarint(key << 3 | 7);
                Collection coll = (Collection)value;
                PContainer desc = (PContainer)descriptor;
                len += out.writeVarint(coll.size());
                for (Object item : coll) {
                    len += this.writeFieldValue(out, 0, desc.itemDescriptor(), item);
                }
                return len;
            }
        }
        throw new SerializerException("", new Object[0]);
    }

    private <T> T readFieldValue(BinaryReader in, int type, PDescriptor descriptor) throws IOException, SerializerException {
        switch (type) {
            case 3: {
                if (descriptor == null) {
                    if (this.readStrict) {
                        throw new SerializerException("", new Object[0]);
                    }
                    in.readLongVarint();
                    return null;
                }
                switch (descriptor.getType()) {
                    case BYTE: {
                        return this.cast((byte)in.readIntZigzag());
                    }
                    case I16: {
                        return this.cast((short)in.readIntZigzag());
                    }
                    case I32: {
                        return this.cast(in.readIntZigzag());
                    }
                    case I64: {
                        return this.cast(in.readLongZigzag());
                    }
                    case ENUM: {
                        PBuilder builder = ((PEnumDescriptor)descriptor).builder();
                        ((PEnumBuilder)builder).setByValue(in.readIntZigzag());
                        return this.cast(builder.build());
                    }
                }
                throw new SerializerException("", new Object[0]);
            }
            case 4: {
                return this.cast(in.expectDouble());
            }
            case 5: {
                int len = in.readIntVarint();
                byte[] data = in.expectBytes(len);
                if (descriptor != null) {
                    switch (descriptor.getType()) {
                        case STRING: {
                            return this.cast(new String(data, StandardCharsets.UTF_8));
                        }
                        case BINARY: {
                            return this.cast(Binary.wrap((byte[])data));
                        }
                    }
                    throw new SerializerException("", new Object[0]);
                }
                if (this.readStrict) {
                    throw new SerializerException("", new Object[0]);
                }
                return null;
            }
            case 6: {
                return this.cast(this.readMessage(in, (PStructDescriptor)descriptor));
            }
            case 7: {
                if (descriptor == null) {
                    if (this.readStrict) {
                        throw new SerializerException("", new Object[0]);
                    }
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        this.readFieldValue(in, in.readIntVarint() & 7, null);
                    }
                    return null;
                }
                if (descriptor.getType() == PType.MAP) {
                    PMap ct = (PMap)descriptor;
                    PDescriptor kt = ct.keyDescriptor();
                    PDescriptor vt = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        T key = this.readFieldValue(in, in.readIntVarint() & 7, kt);
                        T value = this.readFieldValue(in, in.readIntVarint() & 7, vt);
                        out.put(key, value);
                        ++i;
                    }
                    return this.cast(out.build());
                }
                if (descriptor.getType() == PType.LIST) {
                    PList ct = (PList)descriptor;
                    PDescriptor it = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        int tag = in.readIntVarint();
                        out.add(this.readFieldValue(in, tag & 7, it));
                    }
                    return this.cast(out.build());
                }
                if (descriptor.getType() == PType.SET) {
                    PSet ct = (PSet)descriptor;
                    PDescriptor it = ct.itemDescriptor();
                    PBuilder out = ct.builder();
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        int tag = in.readIntVarint();
                        out.add(this.readFieldValue(in, tag & 7, it));
                    }
                    return this.cast(out.build());
                }
                throw new SerializerException("Type " + (Object)((Object)descriptor.getType()) + " not compatible with collection data.", new Object[0]);
            }
            case 1: {
                return this.cast(false);
            }
            case 2: {
                return this.cast(true);
            }
        }
        return null;
    }
}

