/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class BinarySerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.apache.thrift.binary";
    private static final int VERSION_MASK = -65536;
    private static final int VERSION_1 = -2147418112;
    private final boolean readStrict;
    private final boolean versioned;

    public BinarySerializer() {
        this(true);
    }

    public BinarySerializer(boolean readStrict) {
        this(readStrict, false);
    }

    public BinarySerializer(boolean readStrict, boolean versioned) {
        this.readStrict = readStrict;
        this.versioned = versioned;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream os, T message) throws IOException, SerializerException {
        BigEndianBinaryWriter writer = new BigEndianBinaryWriter(os);
        return this.writeMessage((BinaryWriter)writer, message);
    }

    @Override
    public <T extends PMessage<T>> int serialize(OutputStream os, PServiceCall<T> call) throws IOException, SerializerException {
        BigEndianBinaryWriter out = new BigEndianBinaryWriter(os);
        byte[] method = call.getMethod().getBytes(StandardCharsets.UTF_8);
        int len = method.length;
        if (this.versioned) {
            len += out.writeInt(0x80010000 | (byte)call.getType().key);
            len += out.writeInt(method.length);
            out.write(method);
        } else {
            len += out.writeInt(method.length);
            out.write(method);
            len += out.writeByte((byte)call.getType().key);
        }
        len += out.writeInt(call.getSequence());
        return len += this.writeMessage((BinaryWriter)out, call.getMessage());
    }

    @Override
    public <T extends PMessage<T>, TF extends PField> T deserialize(InputStream input, PStructDescriptor<T, TF> descriptor) throws SerializerException, IOException {
        BigEndianBinaryReader reader = new BigEndianBinaryReader(input);
        return this.readMessage((BinaryReader)reader, descriptor, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends PMessage<T>> PServiceCall<T> deserialize(InputStream is, PService service) throws IOException, SerializerException {
        PServiceCallType type;
        int sequence;
        PServiceMethod method;
        String methodName;
        int typeKey;
        BigEndianBinaryReader in = new BigEndianBinaryReader(is);
        int methodNameLen = in.expectInt();
        if (methodNameLen < 0) {
            int version = methodNameLen & 0xFFFF0000;
            if (version != -2147418112) throw new SerializerException("Bad protocol version: %08x", version >>> 16);
            typeKey = methodNameLen & 0xFF;
            methodNameLen = in.expectInt();
            methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
            method = service.getMethod(methodName);
            sequence = in.expectInt();
        } else {
            if (this.readStrict) {
                throw new SerializerException("Missing protocol version", new Object[0]);
            }
            methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
            method = service.getMethod(methodName);
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(null), new Object[0]);
            }
            typeKey = in.expectByte();
            sequence = in.expectInt();
        }
        if ((type = PServiceCallType.findByKey(typeKey)) == null) {
            throw new SerializerException("Invalid call type " + typeKey, new Object[0]);
        }
        PStructDescriptor descriptor = type.request ? method.getRequestType() : method.getResponseType();
        T message = this.readMessage((BinaryReader)in, descriptor, false);
        return new PServiceCall<T>(methodName, type, sequence, message);
    }

    private <T extends PMessage<T>> int writeMessage(BinaryWriter writer, T message) throws IOException, SerializerException {
        int len = 0;
        if (message instanceof PUnion) {
            PField field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        }
        return len += writer.writeUInt8((int)PType.STOP.id);
    }

    private <T extends PMessage<T>> T readMessage(BinaryReader input, PStructDescriptor<T, ?> descriptor, boolean nullable) throws SerializerException, IOException {
        FieldInfo fieldInfo = this.readFieldInfo(input);
        if (nullable && fieldInfo == null) {
            return null;
        }
        PBuilder builder = descriptor.builder();
        while (fieldInfo != null) {
            Object field = descriptor.getField(fieldInfo.getId());
            if (field != null) {
                T value = this.readFieldValue(input, fieldInfo, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
            } else {
                if (this.readStrict) {
                    throw new SerializerException("Unknown field " + fieldInfo.getId() + " for type" + descriptor.getQualifiedName(null), new Object[0]);
                }
                this.readFieldValue(input, fieldInfo, null);
            }
            fieldInfo = this.readFieldInfo(input);
        }
        return (T)((PMessage)builder.build());
    }

    private void consumeMessage(BinaryReader in) throws IOException, SerializerException {
        FieldInfo fieldInfo;
        while ((fieldInfo = this.readFieldInfo(in)) != null) {
            this.readFieldValue(in, fieldInfo, null);
        }
    }

    private FieldInfo readFieldInfo(BinaryReader in) throws IOException, SerializerException {
        byte type = in.expectByte();
        if (type == PType.STOP.id) {
            return null;
        }
        return new FieldInfo(in.expectUInt16(), type);
    }

    private <T> T readFieldValue(BinaryReader in, FieldInfo fieldInfo, PDescriptor type) throws IOException, SerializerException {
        if (type.getType().id != fieldInfo.getType() && this.readStrict) {
            throw new SerializerException("", new Object[0]);
        }
        switch (PType.findById(fieldInfo.getType())) {
            case BOOL: {
                return this.cast(in.expectByte() != 0);
            }
            case BYTE: {
                return this.cast(in.expectByte());
            }
            case I16: {
                return this.cast(in.expectShort());
            }
            case ENUM: 
            case I32: {
                int val = in.expectInt();
                if (type instanceof PEnumDescriptor) {
                    PBuilder builder = ((PEnumDescriptor)type).builder();
                    ((PEnumBuilder)builder).setByValue(val);
                    return this.cast(builder.build());
                }
                return this.cast(val);
            }
            case I64: {
                return this.cast(in.expectLong());
            }
            case DOUBLE: {
                return this.cast(in.expectDouble());
            }
            case STRING: 
            case BINARY: {
                int len = in.expectUInt32();
                byte[] data = in.expectBytes(len);
                if (type.getType() == PType.STRING) {
                    return this.cast(new String(data, StandardCharsets.UTF_8));
                }
                return this.cast(Binary.wrap((byte[])data));
            }
            case MESSAGE: {
                if (type == null) {
                    this.consumeMessage(in);
                    return null;
                }
                return this.cast(this.readMessage(in, (PStructDescriptor)type, false));
            }
            case MAP: {
                PBuilder<Map<T, T>> out;
                byte keyT = in.expectByte();
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor keyType = null;
                PDescriptor valueType = null;
                if (type != null) {
                    if (!type.getType().equals((Object)PType.MAP)) {
                        throw new SerializerException("Invalid type for map encoding: " + type, new Object[0]);
                    }
                    PMap mapType = (PMap)type;
                    keyType = mapType.keyDescriptor();
                    valueType = mapType.itemDescriptor();
                    out = mapType.builder();
                } else {
                    out = new PMap.ImmutableMapBuilder();
                }
                FieldInfo keyInfo = new FieldInfo(1, keyT);
                FieldInfo itemInfo = new FieldInfo(2, itemT);
                for (int i = 0; i < size; ++i) {
                    T key = this.readFieldValue(in, keyInfo, keyType);
                    T value = this.readFieldValue(in, itemInfo, valueType);
                    if (key != null && value != null) {
                        out.put(key, value);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null key or value in map.", new Object[0]);
                }
                return this.cast(out.build());
            }
            case SET: {
                PBuilder<Set<T>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PSet setType = (PSet)type;
                    entryType = setType.itemDescriptor();
                    out = setType.builder();
                } else {
                    out = new PSet.ImmutableSetBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    T key = this.readFieldValue(in, itemInfo, entryType);
                    if (key != null) {
                        out.add(key);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null value in set.", new Object[0]);
                }
                return this.cast(out.build());
            }
            case LIST: {
                PBuilder out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PList listType = (PList)type;
                    entryType = listType.itemDescriptor();
                    out = listType.builder();
                } else {
                    out = new PList.ImmutableListBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    T key = this.readFieldValue(in, itemInfo, entryType);
                    if (key != null) {
                        out.add(key);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null value in list.", new Object[0]);
                }
                return this.cast(out.build());
            }
        }
        throw new SerializerException("unknown data type: " + fieldInfo.getType(), new Object[0]);
    }

    private int writeFieldSpec(BinaryWriter out, byte type, int key) throws IOException {
        out.writeByte(type);
        out.writeUInt16(key);
        return 3;
    }

    private int writeFieldValue(BinaryWriter out, Object value, PDescriptor descriptor) throws IOException, SerializerException {
        switch (descriptor.getType()) {
            case BOOL: {
                return out.writeByte((Boolean)value != false ? (byte)1 : 0);
            }
            case BYTE: {
                return out.writeByte(((Byte)value).byteValue());
            }
            case I16: {
                return out.writeShort(((Short)value).shortValue());
            }
            case I32: {
                return out.writeInt(((Integer)value).intValue());
            }
            case I64: {
                return out.writeLong(((Long)value).longValue());
            }
            case DOUBLE: {
                return out.writeDouble(((Double)value).doubleValue());
            }
            case BINARY: {
                Binary binary = (Binary)value;
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case STRING: {
                Binary binary = Binary.wrap((byte[])value.toString().getBytes(StandardCharsets.UTF_8));
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case ENUM: {
                return out.writeInt(((PEnumValue)value).getValue());
            }
            case MAP: {
                Map map = (Map)value;
                PMap pMap = (PMap)descriptor;
                int len = out.writeByte(pMap.keyDescriptor().getType().id);
                len += out.writeByte(pMap.itemDescriptor().getType().id);
                len += out.writeUInt32(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    len += this.writeFieldValue(out, entry.getKey(), pMap.keyDescriptor());
                    len += this.writeFieldValue(out, entry.getValue(), pMap.itemDescriptor());
                }
                return len;
            }
            case SET: 
            case LIST: {
                Collection coll = (Collection)value;
                PContainer pSet = (PContainer)descriptor;
                int len = out.writeByte(pSet.itemDescriptor().getType().id);
                len += out.writeUInt32(coll.size());
                for (Object item : coll) {
                    len += this.writeFieldValue(out, item, pSet.itemDescriptor());
                }
                return len;
            }
            case MESSAGE: {
                int size = this.writeMessage(out, (PMessage)value);
                return size;
            }
        }
        throw new SerializerException("", new Object[0]);
    }

    private static class FieldInfo {
        private final int id;
        private final byte type;

        private FieldInfo(int id, byte type) {
            this.id = id;
            this.type = type;
        }

        public String toString() {
            return String.format("field(%d: %s)", new Object[]{this.id, PType.findById(this.type)});
        }

        public int getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }
    }
}

