/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PList<I>
extends PContainer<List<I>> {
    private final BuilderFactory<I> builderFactory;

    public PList(PDescriptorProvider itemType, BuilderFactory<I> builderFactory) {
        super(itemType);
        this.builderFactory = builderFactory;
    }

    @Override
    public String getName() {
        return "list<" + this.itemDescriptor().getName() + ">";
    }

    @Override
    public String getQualifiedName(String packageName) {
        return "list<" + this.itemDescriptor().getQualifiedName(packageName) + ">";
    }

    @Override
    public PType getType() {
        return PType.LIST;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PList)) {
            return false;
        }
        PList other = (PList)o;
        return other.itemDescriptor().equals(this.itemDescriptor());
    }

    public int hashCode() {
        return PList.class.hashCode() + this.itemDescriptor().hashCode();
    }

    @Override
    public Builder<I> builder() {
        return this.builderFactory.builder();
    }

    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc) {
        BuilderFactory factory = new BuilderFactory<I>(){

            @Override
            public Builder<I> builder() {
                return new ImmutableListBuilder();
            }
        };
        return PList.provider(itemDesc, factory);
    }

    public static <I> PContainerProvider<List<I>, PList<I>> provider(PDescriptorProvider itemDesc, BuilderFactory<I> builderFactory) {
        return new PContainerProvider<List<I>, PList<I>>(new PList<I>(itemDesc, builderFactory));
    }

    public static class ImmutableListBuilder<I>
    implements Builder<I> {
        private ImmutableList.Builder<I> builder = ImmutableList.builder();

        @Override
        public void add(I value) {
            this.builder.add(value);
        }

        @Override
        public void addAll(Collection<I> items) {
            this.builder.addAll(items);
        }

        @Override
        public void clear() {
            this.builder = ImmutableList.builder();
        }

        @Override
        public List<I> build() {
            return this.builder.build();
        }
    }

    public static interface BuilderFactory<I>
    extends PBuilderFactory<List<I>> {
        @Override
        public Builder<I> builder();
    }

    public static interface Builder<V>
    extends PBuilder<List<V>> {
        public void add(V var1);

        public void addAll(Collection<V> var1);

        public void clear();

        @Override
        public List<V> build();
    }
}

