/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PSerializeException;
import net.morimekta.providence.serializer.PSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class PProtoSerializer
extends PSerializer {
    private final boolean strict;
    private static final int VARINT = 0;
    private static final int FIXED_64 = 1;
    private static final int BINARY = 2;

    public PProtoSerializer() {
        this(false);
    }

    public PProtoSerializer(boolean strict) {
        this.strict = strict;
    }

    @Override
    public int serialize(OutputStream output, PMessage<?> message) throws IOException, PSerializeException {
        BinaryWriter writer = new BinaryWriter(output);
        return this.writeMessage(writer, message);
    }

    @Override
    public <T> int serialize(OutputStream output, PDescriptor<T> descriptor, T value) throws IOException, PSerializeException {
        try {
            BinaryWriter writer = new BinaryWriter(output);
            if (PType.MESSAGE == descriptor.getType()) {
                return this.writeMessage(writer, (PMessage)value);
            }
            int type = PProtoSerializer.getType(descriptor.getType());
            return this.writeFieldValue(writer, type, descriptor, value);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to write to stream", new Object[0]);
        }
    }

    @Override
    public <T> T deserialize(InputStream input, PDescriptor<T> descriptor) throws PSerializeException, IOException {
        BinaryReader reader = new BinaryReader(input);
        if (PType.MESSAGE == descriptor.getType()) {
            return this.cast(this.readMessage(reader, (PStructDescriptor)descriptor));
        }
        int tag = PProtoSerializer.getType(descriptor.getType());
        return this.readFieldValue(reader, tag, descriptor);
    }

    protected int writeMessage(BinaryWriter writer, PMessage<?> message) throws IOException, PSerializeException {
        int len = 0;
        if (message instanceof PUnion) {
            PField<?> field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeMessageField(writer, field, message);
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeMessageField(writer, field, message);
            }
        }
        return len;
    }

    private int writeMessageField(BinaryWriter writer, PField field, PMessage<?> message) throws IOException, PSerializeException {
        int len = 0;
        if (field.getType() == PType.SET || field.getType() == PType.LIST) {
            PContainer ct = (PContainer)field.getDescriptor();
            int type = PProtoSerializer.getType(ct.itemDescriptor().getType());
            int tag = field.getKey() << 3 | type;
            Collection container = (Collection)message.get(field.getKey());
            for (Object item : container) {
                len += writer.writeVarint(tag);
                len += this.writeFieldValue(writer, type, ct.itemDescriptor(), item);
            }
        } else {
            int type = PProtoSerializer.getType(field.getType());
            int tag = field.getKey() << 3 | type;
            len += writer.writeVarint(tag);
            len += this.writeFieldValue(writer, type, field.getDescriptor(), message.get(field.getKey()));
        }
        return len;
    }

    private <T extends PMessage<T>> T readMessage(BinaryReader input, PStructDescriptor<T, ?> descriptor) throws PSerializeException, IOException {
        int tag;
        PBuilder builder = ((PMessageBuilderFactory)descriptor.factory()).builder();
        while ((tag = input.readIntVarint()) > 0) {
            int id = tag >>> 3;
            int type = tag & 7;
            Object field = descriptor.getField(id);
            if (field != null) {
                if ((field.getType() == PType.LIST || field.getType() == PType.SET) && type != 2) {
                    PContainer ct = (PContainer)field.getDescriptor();
                    Object value = this.readFieldValue(input, type, ct.itemDescriptor());
                    ((PMessageBuilder)builder).addTo(field.getKey(), value);
                    continue;
                }
                Object value = this.readFieldValue(input, type, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
                continue;
            }
            if (this.strict) {
                throw new PSerializeException("Unknown field " + id + " for type" + descriptor.getQualifiedName(null), new Object[0]);
            }
            this.readFieldValue(input, type, null);
        }
        return (T)((PMessage)builder.build());
    }

    protected <T> T readFieldValue(BinaryReader in, int type, PDescriptor<T> descriptor) throws IOException, PSerializeException {
        switch (type) {
            case 0: {
                if (descriptor != null) {
                    switch (descriptor.getType()) {
                        case BOOL: {
                            return this.cast(in.readIntZigzag() > 0);
                        }
                        case BYTE: {
                            return this.cast((byte)in.readIntZigzag());
                        }
                        case I16: {
                            return this.cast((short)in.readIntZigzag());
                        }
                        case I32: {
                            return this.cast(in.readIntZigzag());
                        }
                        case I64: {
                            return this.cast(in.readLongZigzag());
                        }
                        case ENUM: {
                            PBuilder builder = ((PEnumBuilderFactory)((PEnumDescriptor)descriptor).factory()).builder();
                            ((PEnumBuilder)builder).setByValue(in.readIntZigzag());
                            return this.cast(builder.build());
                        }
                    }
                    throw new PSerializeException("invalid type for varint value: " + descriptor.getName(), new Object[0]);
                }
                in.readLongVarint();
                return null;
            }
            case 1: {
                if (descriptor == null) {
                    if (this.strict) {
                        throw new PSerializeException("", new Object[0]);
                    }
                } else {
                    if (descriptor.getType() == PType.DOUBLE) {
                        return this.cast(in.expectDouble());
                    }
                    throw new PSerializeException("invalid type for fixed_64 value " + descriptor, new Object[0]);
                }
                in.expectLong();
                return null;
            }
            case 2: {
                int len = in.readIntVarint();
                byte[] bytes = in.expectBytes(len);
                if (descriptor != null) {
                    switch (descriptor.getType()) {
                        case STRING: {
                            return this.cast(new String(bytes, StandardCharsets.UTF_8));
                        }
                        case BINARY: {
                            return this.cast(Binary.wrap((byte[])bytes));
                        }
                        case MESSAGE: {
                            ByteArrayInputStream tmp = new ByteArrayInputStream(bytes);
                            return this.deserialize(tmp, descriptor);
                        }
                        case SET: 
                        case LIST: {
                            ByteArrayInputStream tmp = new ByteArrayInputStream(bytes);
                            BinaryReader reader = new BinaryReader((InputStream)tmp);
                            PContainer ct = (PContainer)descriptor;
                            PDescriptor it = ct.itemDescriptor();
                            AbstractCollection out = descriptor.getType() == PType.SET ? new LinkedHashSet() : new LinkedList();
                            int itag = reader.readIntVarint() & 7;
                            while (tmp.available() > 0) {
                                out.add(this.readFieldValue(reader, itag, it));
                            }
                            return this.cast(out);
                        }
                        case MAP: {
                            int ktag;
                            ByteArrayInputStream tmp = new ByteArrayInputStream(bytes);
                            BinaryReader reader = new BinaryReader((InputStream)tmp);
                            PMap ct = (PMap)descriptor;
                            PDescriptor kt = ct.keyDescriptor();
                            PDescriptor vt = ct.itemDescriptor();
                            LinkedHashMap out = new LinkedHashMap();
                            while ((ktag = reader.readIntVarint()) > 0) {
                                Object key = this.readFieldValue(reader, ktag & 7, kt);
                                int vTag = reader.readIntVarint();
                                Object value = this.readFieldValue(reader, vTag & 7, vt);
                                out.put(key, value);
                            }
                            return this.cast(out);
                        }
                    }
                    throw new PSerializeException("Illegal type for binary encoding: " + descriptor, new Object[0]);
                }
                if (this.strict) {
                    throw new PSerializeException("", new Object[0]);
                }
                return null;
            }
        }
        throw new PSerializeException("Unknown type: " + type, new Object[0]);
    }

    protected int writeFieldValue(BinaryWriter out, int tag, PDescriptor<?> descriptor, Object value) throws IOException, PSerializeException {
        int len = 0;
        switch (tag) {
            case 0: {
                if (value instanceof Boolean) {
                    len += out.writeVarint((Boolean)value != false ? 1 : 0);
                    break;
                }
                if (value instanceof Byte) {
                    len += out.writeZigzag((int)((Byte)value).byteValue());
                    break;
                }
                if (value instanceof Short) {
                    len += out.writeZigzag((int)((Short)value).shortValue());
                    break;
                }
                if (value instanceof Integer) {
                    len += out.writeZigzag(((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    len += out.writeZigzag(((Long)value).longValue());
                    break;
                }
                if (value instanceof PEnumValue) {
                    len += out.writeZigzag(((PEnumValue)value).getValue());
                    break;
                }
                throw new PSerializeException("", new Object[0]);
            }
            case 1: {
                if (value instanceof Double) {
                    len += out.writeDouble(((Double)value).doubleValue());
                    break;
                }
                throw new PSerializeException("", new Object[0]);
            }
            case 2: {
                if (value instanceof String) {
                    byte[] data = ((String)value).getBytes(StandardCharsets.UTF_8);
                    len += out.writeVarint(data.length);
                    out.write(data);
                    len += data.length;
                    break;
                }
                if (value instanceof Binary) {
                    Binary binary = (Binary)value;
                    len += out.writeVarint(binary.length());
                    len += out.writeBinary(binary);
                    break;
                }
                if (value instanceof PMessage) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
                    len += this.serialize(baos, (PMessage)value);
                    len += out.writeVarint(baos.size());
                    out.write(baos.toByteArray(), 0, baos.size());
                    break;
                }
                if (value instanceof Collection) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BinaryWriter packedWriter = new BinaryWriter((OutputStream)baos);
                    PContainer ct = (PContainer)descriptor;
                    int iTag = PProtoSerializer.getType(ct.itemDescriptor().getType());
                    Collection coll = (Collection)value;
                    packedWriter.writeVarint(iTag);
                    for (Object item : coll) {
                        this.writeFieldValue(packedWriter, iTag, ct.itemDescriptor(), item);
                    }
                    packedWriter.flush();
                    len += out.writeVarint(baos.size());
                    out.write(baos.toByteArray(), 0, baos.size());
                    len += baos.size();
                    break;
                }
                if (value instanceof Map) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BinaryWriter mapWriter = new BinaryWriter((OutputStream)baos);
                    PMap ct = (PMap)descriptor;
                    int kTag = PProtoSerializer.getType(ct.keyDescriptor().getType());
                    int vTag = PProtoSerializer.getType(ct.itemDescriptor().getType());
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        mapWriter.writeVarint(8 | kTag);
                        this.writeFieldValue(mapWriter, kTag, ct.keyDescriptor(), entry.getKey());
                        mapWriter.writeVarint(0x10 | vTag);
                        this.writeFieldValue(mapWriter, vTag, ct.itemDescriptor(), entry.getValue());
                    }
                    mapWriter.flush();
                    len += out.writeVarint(baos.size());
                    out.write(baos.toByteArray(), 0, baos.size());
                    len += baos.size();
                    break;
                }
                throw new PSerializeException("", new Object[0]);
            }
            default: {
                throw new PSerializeException("", new Object[0]);
            }
        }
        return len;
    }

    private static int getType(PType type) throws PSerializeException {
        switch (type) {
            case BOOL: 
            case BYTE: 
            case I16: 
            case I32: 
            case I64: 
            case ENUM: {
                return 0;
            }
            case DOUBLE: {
                return 1;
            }
            case STRING: 
            case BINARY: 
            case MESSAGE: 
            case SET: 
            case LIST: 
            case MAP: {
                return 2;
            }
        }
        throw new PSerializeException("", new Object[0]);
    }
}

