/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PSerializeException;
import net.morimekta.providence.serializer.PSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.CountingOutputStream;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;
import net.morimekta.util.json.JsonWriter;
import net.morimekta.util.json.PrettyJsonWriter;

public class PJsonSerializer
extends PSerializer {
    public static final byte[] STREAM_INITIATOR = new byte[]{123};
    public static final byte[] ENTRY_SEP = new byte[]{10};
    private final boolean readStrict;
    private final IdType idType;
    private final IdType enumType;
    private final boolean pretty;

    public PJsonSerializer() {
        this(true, IdType.ID, IdType.ID, false);
    }

    public PJsonSerializer(boolean strict) {
        this(strict, IdType.ID, IdType.ID, false);
    }

    public PJsonSerializer(IdType idType) {
        this(true, idType, idType, false);
    }

    public PJsonSerializer(boolean readStrict, IdType idType) {
        this(readStrict, idType, idType, false);
    }

    public PJsonSerializer(IdType idType, IdType enumType) {
        this(true, idType, enumType, false);
    }

    public PJsonSerializer(boolean readStrict, IdType idType, IdType enumType, boolean pretty) {
        this.readStrict = readStrict;
        this.idType = idType;
        this.enumType = enumType;
        this.pretty = pretty;
    }

    @Override
    public byte[] streamInitiator() {
        return STREAM_INITIATOR;
    }

    @Override
    public int serialize(OutputStream output, PMessage<?> message) throws PSerializeException {
        CountingOutputStream counter = new CountingOutputStream(output);
        PrettyJsonWriter jsonWriter = this.pretty ? new PrettyJsonWriter((OutputStream)counter) : new JsonWriter((OutputStream)counter);
        try {
            this.appendMessage((JsonWriter)jsonWriter, message);
            jsonWriter.flush();
            counter.flush();
            return counter.getByteCount();
        }
        catch (JsonException e) {
            throw new PSerializeException(e, "Unable to serialize JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to writeBinary to stream", new Object[0]);
        }
    }

    @Override
    public <T> int serialize(OutputStream output, PDescriptor<T> descriptor, T value) throws IOException, PSerializeException {
        CountingOutputStream counter = new CountingOutputStream(output);
        JsonWriter jsonWriter = new JsonWriter((OutputStream)counter);
        try {
            this.appendTypedValue(jsonWriter, descriptor, value);
            jsonWriter.flush();
            counter.flush();
            return counter.getByteCount();
        }
        catch (JsonException e) {
            throw new PSerializeException(e, "Unable to serialize JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to writeBinary to stream", new Object[0]);
        }
    }

    @Override
    public <T> T deserialize(InputStream input, PDescriptor<T> type) throws PSerializeException {
        try {
            JsonTokenizer tokenizer = new JsonTokenizer(input);
            if (!tokenizer.hasNext()) {
                return null;
            }
            return this.parseTypedValue(tokenizer.next(), tokenizer, type);
        }
        catch (JsonException e) {
            throw new PSerializeException(e, "Unable to parse JSON", new Object[0]);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to read stream", new Object[0]);
        }
    }

    protected <T extends PMessage<T>> T parseMessage(JsonTokenizer tokenizer, PStructDescriptor<T, ?> type) throws PSerializeException, JsonException, IOException {
        PBuilder builder = ((PMessageBuilderFactory)type.factory()).builder();
        if (!tokenizer.peek("checking for empty message").isSymbol('}')) {
            int sep = 123;
            while (sep != 125) {
                JsonToken token = tokenizer.expect("parsing message key");
                String key = token.substring(1, -1).asString();
                Object field = Strings.isInteger((String)key) ? type.getField(Integer.parseInt(key)) : type.getField(key);
                tokenizer.expectSymbol("parsing message field key sep", new char[]{':'});
                if (field != null) {
                    Object value = this.parseTypedValue(tokenizer.expect("parsing message field value"), tokenizer, field.getDescriptor());
                    ((PMessageBuilder)builder).set(field.getKey(), value);
                } else {
                    if (this.readStrict) {
                        throw new PSerializeException("Unknown field " + key + " for type " + type.getQualifiedName(null), new Object[0]);
                    }
                    this.consume(tokenizer.expect("consuming unknown message value"), tokenizer);
                }
                sep = tokenizer.expectSymbol("parsing message entry sep", new char[]{'}', ','});
            }
        }
        if (this.readStrict && !((PMessageBuilder)builder).isValid()) {
            throw new PSerializeException("Type " + type.getName() + " not properly populated", new Object[0]);
        }
        return (T)((PMessage)builder.build());
    }

    protected <T extends PMessage<T>> T parseCompactMessage(JsonTokenizer tokenizer, PStructDescriptor<T, ?> type) throws PSerializeException, IOException, JsonException {
        PBuilder builder = ((PMessageBuilderFactory)type.factory()).builder();
        int i = 0;
        int sep = 91;
        while (sep != 93) {
            Object field;
            if ((field = type.getField(++i)) != null) {
                Object value = this.parseTypedValue(tokenizer.expect("parsing compact message field value"), tokenizer, field.getDescriptor());
                ((PMessageBuilder)builder).set(i, value);
            } else {
                if (this.readStrict) {
                    throw new PSerializeException("Compact Field ID " + i + " outside field spectrum for type " + type.getQualifiedName(null), new Object[0]);
                }
                this.consume(tokenizer.expect("consuming compact message field value"), tokenizer);
            }
            sep = tokenizer.expectSymbol("parsing compact message entry sep", new char[]{']', ','});
        }
        if (this.readStrict && !((PMessageBuilder)builder).isValid()) {
            throw new PSerializeException("Type " + type.getName() + " not properly populated", new Object[0]);
        }
        return (T)((PMessage)builder.build());
    }

    private void consume(JsonToken token, JsonTokenizer tokenizer) throws IOException, JsonException {
        block6: {
            block7: {
                if (!token.isSymbol()) break block6;
                if (!token.isSymbol('[')) break block7;
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                } else {
                    int sep = 91;
                    while (sep != 93) {
                        this.consume(tokenizer.expect("consuming list item"), tokenizer);
                        sep = tokenizer.expectSymbol("consuming list sep", new char[]{']', ','});
                    }
                }
                break block6;
            }
            if (!token.isSymbol('{')) break block6;
            if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                tokenizer.next();
            } else {
                int sep = 123;
                while (sep != 125) {
                    tokenizer.expectString("consuming map key");
                    tokenizer.expectSymbol("consuming map kv sep", new char[]{':'});
                    this.consume(tokenizer.expect("consuming map value"), tokenizer);
                    sep = tokenizer.expectSymbol("consuming map entry sep", new char[]{'}', ','});
                }
            }
        }
    }

    protected <T> T parseTypedValue(JsonToken token, JsonTokenizer tokenizer, PDescriptor<T> t) throws IOException, PSerializeException {
        if (token.isNull()) {
            return null;
        }
        try {
            switch (t.getType()) {
                case BOOL: {
                    if (token.isBoolean()) {
                        return this.cast(token.booleanValue());
                    }
                    if (token.isInteger()) {
                        return this.cast(token.intValue() != 0);
                    }
                    throw new PSerializeException("Not boolean value for token: " + token.asString(), new Object[0]);
                }
                case BYTE: {
                    if (token.isInteger()) {
                        return this.cast(token.byteValue());
                    }
                    throw new PSerializeException("Not a valid byte value: " + token.asString(), new Object[0]);
                }
                case I16: {
                    if (token.isInteger()) {
                        return this.cast(token.shortValue());
                    }
                    throw new PSerializeException("Not a valid short value: " + token.asString(), new Object[0]);
                }
                case I32: {
                    if (token.isInteger()) {
                        return this.cast(token.intValue());
                    }
                    throw new PSerializeException("Not a valid int value: " + token.asString(), new Object[0]);
                }
                case I64: {
                    if (token.isInteger()) {
                        return this.cast(token.longValue());
                    }
                    throw new PSerializeException("Not a valid long value: " + token.asString(), new Object[0]);
                }
                case DOUBLE: {
                    if (token.isNumber()) {
                        return this.cast(token.doubleValue());
                    }
                    throw new PSerializeException("Not a valid double value: " + token.asString(), new Object[0]);
                }
                case STRING: {
                    if (token.isLiteral()) {
                        return this.cast(token.decodeJsonLiteral());
                    }
                    throw new PSerializeException("Not a valid string value: " + token.asString(), new Object[0]);
                }
                case BINARY: {
                    if (token.isLiteral()) {
                        return this.cast(Binary.fromBase64((String)token.substring(1, -1).asString()));
                    }
                    throw new PSerializeException("Not a valid binary value: " + token.asString(), new Object[0]);
                }
                case ENUM: {
                    PBuilder eb = ((PEnumBuilderFactory)((PEnumDescriptor)t).factory()).builder();
                    if (token.isInteger()) {
                        ((PEnumBuilder)eb).setByValue(token.intValue());
                    } else if (token.isLiteral()) {
                        ((PEnumBuilder)eb).setByName(token.substring(1, -1).asString());
                    } else {
                        throw new PSerializeException(token.toString() + " is not a enum value type", new Object[0]);
                    }
                    if (this.readStrict && !((PEnumBuilder)eb).isValid()) {
                        throw new PSerializeException(token.toString() + " is not a enum value", new Object[0]);
                    }
                    return this.cast(eb.build());
                }
                case MESSAGE: {
                    PStructDescriptor st = (PStructDescriptor)t;
                    if (token.isSymbol('{')) {
                        return this.cast(this.parseMessage(tokenizer, st));
                    }
                    if (token.isSymbol('[')) {
                        if (st.isCompactible()) {
                            return this.cast(this.parseCompactMessage(tokenizer, st));
                        }
                        throw new PSerializeException(st.getName() + " is not compatible for compact struct notation.", new Object[0]);
                    }
                    throw new PSerializeException(token + " not parsable message start.", new Object[0]);
                }
                case MAP: {
                    PDescriptor itemType = ((PMap)t).itemDescriptor();
                    PDescriptor keyType = ((PMap)t).keyDescriptor();
                    if (!token.isSymbol('{')) {
                        throw new PSerializeException("Incompatible start of map " + token, new Object[0]);
                    }
                    LinkedHashMap map = new LinkedHashMap();
                    if (!tokenizer.peek("checking for empty map").isSymbol('}')) {
                        int sep = 123;
                        while (sep != 125) {
                            Object key = this.parseMapKey(tokenizer.expectString("parsing map key").decodeJsonLiteral(), keyType);
                            tokenizer.expectSymbol("parsing map K/V sep", new char[]{':'});
                            Object value = this.parseTypedValue(tokenizer.expect("parsing map value"), tokenizer, itemType);
                            map.put(key, value);
                            sep = tokenizer.expectSymbol("parsing map entry sep", new char[]{'}', ','});
                        }
                    }
                    return this.cast(map);
                }
                case SET: {
                    PDescriptor itemType = ((PSet)t).itemDescriptor();
                    if (!token.isSymbol('[')) {
                        throw new PSerializeException("Incompatible start of list " + token, new Object[0]);
                    }
                    LinkedHashSet set = new LinkedHashSet();
                    if (!tokenizer.peek("checking for empty set").isSymbol(']')) {
                        int sep = 91;
                        while (sep != 93) {
                            set.add(this.parseTypedValue(tokenizer.expect("parsing set value"), tokenizer, itemType));
                            sep = tokenizer.expectSymbol("parsing set entry sep", new char[]{',', ']'});
                        }
                    }
                    return this.cast(set);
                }
                case LIST: {
                    PDescriptor itemType = ((PList)t).itemDescriptor();
                    if (!token.isSymbol('[')) {
                        throw new PSerializeException("Incompatible start of list " + token, new Object[0]);
                    }
                    LinkedList list = new LinkedList();
                    if (!tokenizer.peek("checking for empty list").isSymbol(']')) {
                        int sep = 91;
                        while (sep != 93) {
                            list.add(this.parseTypedValue(tokenizer.expect("parsing list value"), tokenizer, itemType));
                            sep = tokenizer.expectSymbol("parsing list entry sep", new char[]{',', ']'});
                        }
                    }
                    return this.cast(list);
                }
            }
        }
        catch (JsonException je) {
            throw new PSerializeException(je, "Unable to parse type value.", new Object[0]);
        }
        catch (ClassCastException ce) {
            throw new PSerializeException(ce, "Serialized type  not compatible with " + t.getQualifiedName(null), new Object[0]);
        }
        throw new PSerializeException("Unhandled item type " + t.getQualifiedName(null), new Object[0]);
    }

    protected Object parseMapKey(String key, PDescriptor keyType) throws PSerializeException {
        try {
            switch (keyType.getType()) {
                case BOOL: {
                    return Boolean.parseBoolean(key);
                }
                case BYTE: {
                    return Byte.parseByte(key);
                }
                case I16: {
                    return Short.parseShort(key);
                }
                case I32: {
                    return Integer.parseInt(key);
                }
                case I64: {
                    return Long.parseLong(key);
                }
                case DOUBLE: {
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)new ByteArrayInputStream(key.getBytes()));
                        JsonToken token = tokenizer.next();
                        if (!token.isNumber()) {
                            throw new PSerializeException(key + " is not a number", new Object[0]);
                        }
                        return token.doubleValue();
                    }
                    catch (JsonException e) {
                        throw new PSerializeException(e, "Unable to parse double from key \"" + key + "\"", new Object[0]);
                    }
                    catch (IOException e) {
                        throw new PSerializeException(e, "Unable to parse double from key \"" + key + "\" (IO)", new Object[0]);
                    }
                }
                case STRING: {
                    return key;
                }
                case BINARY: {
                    try {
                        return Binary.fromBase64((String)key);
                    }
                    catch (IOException e) {
                        throw new PSerializeException(e, "Unable to parse Base64 data.", new Object[0]);
                    }
                }
                case ENUM: {
                    PBuilder eb = ((PEnumBuilderFactory)((PEnumDescriptor)keyType).factory()).builder();
                    if (Strings.isInteger((String)key)) {
                        ((PEnumBuilder)eb).setByValue(Integer.parseInt(key));
                    } else {
                        ((PEnumBuilder)eb).setByName(key);
                    }
                    if (this.readStrict && !((PEnumBuilder)eb).isValid()) {
                        throw new PSerializeException(key + " is not a valid enum value for " + keyType.getQualifiedName(null), new Object[0]);
                    }
                    return eb.build();
                }
                case MESSAGE: {
                    PStructDescriptor st = (PStructDescriptor)keyType;
                    if (!st.isSimple()) {
                        throw new PSerializeException("Only simple structs can be used as map key. " + st.getQualifiedName(null) + " is not.", new Object[0]);
                    }
                    ByteArrayInputStream input = new ByteArrayInputStream(key.getBytes(StandardCharsets.UTF_8));
                    try {
                        JsonTokenizer tokenizer = new JsonTokenizer((InputStream)input);
                        tokenizer.expectSymbol("Message start", new char[]{'{'});
                        return this.cast(this.parseMessage(tokenizer, st));
                    }
                    catch (IOException e) {
                        throw new PSerializeException(e, "Unable to tokenize map key: " + key, new Object[0]);
                    }
                    catch (JsonException e) {
                        throw new PSerializeException(e, "Unable to parse map key: " + key, new Object[0]);
                    }
                }
            }
            throw new PSerializeException("Illegal key type: " + (Object)((Object)keyType.getType()), new Object[0]);
        }
        catch (NumberFormatException nfe) {
            throw new PSerializeException(nfe, "Unable to parse numeric value " + key, new Object[0]);
        }
    }

    protected void appendMessage(JsonWriter writer, PMessage<?> message) throws PSerializeException, JsonException {
        PStructDescriptor<?, ?> type = message.descriptor();
        if (message instanceof PUnion) {
            writer.object();
            PField<?> field = ((PUnion)message).unionField();
            if (field != null) {
                Object value = message.get(field.getKey());
                if (IdType.ID.equals((Object)this.idType)) {
                    writer.key(field.getKey());
                } else {
                    writer.key((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        } else if (message.isCompact()) {
            writer.array();
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) break;
                this.appendTypedValue(writer, field.getDescriptor(), message.get(field.getKey()));
            }
            writer.endArray();
        } else {
            writer.object();
            for (PField field : type.getFields()) {
                if (!message.has(field.getKey())) continue;
                Object value = message.get(field.getKey());
                if (IdType.ID.equals((Object)this.idType)) {
                    writer.key(field.getKey());
                } else {
                    writer.key((CharSequence)field.getName());
                }
                this.appendTypedValue(writer, field.getDescriptor(), value);
            }
            writer.endObject();
        }
    }

    protected void appendTypedValue(JsonWriter writer, PDescriptor type, Object value) throws PSerializeException, JsonException {
        switch (type.getType()) {
            case MESSAGE: {
                PMessage message = (PMessage)value;
                this.appendMessage(writer, message);
                break;
            }
            case MAP: {
                writer.object();
                PMap mapType = (PMap)type;
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.appendPrimitiveKey(writer, entry.getKey());
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.endObject();
                break;
            }
            case SET: 
            case LIST: {
                writer.array();
                PContainer containerType = (PContainer)type;
                Collection collection = (Collection)value;
                for (Object i : collection) {
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.endArray();
                break;
            }
            default: {
                this.appendPrimitive(writer, value);
            }
        }
    }

    protected void appendPrimitiveKey(JsonWriter writer, Object primitive) throws JsonException, PSerializeException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.idType)) {
                writer.key(((PEnumValue)primitive).getValue());
            } else {
                writer.key((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.key(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.key(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.key(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.key(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.key(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.key(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.key((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.key((Binary)primitive);
        } else if (primitive instanceof PMessage) {
            PMessage message = (PMessage)primitive;
            if (!message.isSimple()) {
                throw new PSerializeException("Only simple messages can be used as map keys. " + message.descriptor().getQualifiedName(null) + " is not.", new Object[0]);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter json = new JsonWriter((OutputStream)baos);
            this.appendMessage(json, message);
            json.flush();
            writer.key((CharSequence)new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else {
            throw new PSerializeException("illegal simple type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    protected void appendPrimitive(JsonWriter writer, Object primitive) throws JsonException, PSerializeException {
        if (primitive instanceof PEnumValue) {
            if (IdType.ID.equals((Object)this.enumType)) {
                writer.value(((PEnumValue)primitive).getValue());
            } else {
                writer.value((CharSequence)primitive.toString());
            }
        } else if (primitive instanceof Boolean) {
            writer.value(((Boolean)primitive).booleanValue());
        } else if (primitive instanceof Byte) {
            writer.value(((Byte)primitive).byteValue());
        } else if (primitive instanceof Short) {
            writer.value(((Short)primitive).shortValue());
        } else if (primitive instanceof Integer) {
            writer.value(((Integer)primitive).intValue());
        } else if (primitive instanceof Long) {
            writer.value(((Long)primitive).longValue());
        } else if (primitive instanceof Double) {
            writer.value(((Double)primitive).doubleValue());
        } else if (primitive instanceof String) {
            writer.value((CharSequence)((String)primitive));
        } else if (primitive instanceof Binary) {
            writer.value((Binary)primitive);
        } else {
            throw new PSerializeException("illegal primitive type class " + primitive.getClass().getSimpleName(), new Object[0]);
        }
    }

    public static enum IdType {
        ID,
        NAME;

    }
}

