/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PSerializeException;
import net.morimekta.providence.serializer.PSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class PFastBinarySerializer
extends PSerializer {
    protected final boolean readStrict;
    protected static final int NONE = 0;
    protected static final int TRUE = 1;
    protected static final int VARINT = 2;
    protected static final int FIXED_64 = 3;
    protected static final int BINARY = 4;
    protected static final int MESSAGE = 5;
    protected static final int COLLECTION = 6;

    public PFastBinarySerializer() {
        this(false);
    }

    public PFastBinarySerializer(boolean readStrict) {
        this.readStrict = readStrict;
    }

    @Override
    public int serialize(OutputStream os, PMessage<?> message) throws IOException, PSerializeException {
        BinaryWriter out = new BinaryWriter(os);
        return this.writeMessage(out, message);
    }

    @Override
    public <T> int serialize(OutputStream os, PDescriptor<T> descriptor, T value) throws IOException, PSerializeException {
        try {
            BinaryWriter out = new BinaryWriter(os);
            if (PType.MESSAGE == descriptor.getType()) {
                return this.writeMessage(out, (PMessage)value);
            }
            return this.writeFieldValue(out, 0, descriptor, value);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to write to stream", new Object[0]);
        }
    }

    @Override
    public <T> T deserialize(InputStream is, PDescriptor<T> descriptor) throws PSerializeException, IOException {
        BinaryReader in = new BinaryReader(is);
        if (PType.MESSAGE == descriptor.getType()) {
            return this.cast(this.readMessage(in, (PStructDescriptor)descriptor));
        }
        int tag = in.readIntVarint();
        if (tag > 0) {
            return this.readFieldValue(in, tag & 0xF, descriptor);
        }
        if (this.readStrict) {
            throw new PSerializeException("", new Object[0]);
        }
        return null;
    }

    protected int writeMessage(BinaryWriter out, PMessage<?> message) throws IOException, PSerializeException {
        int len = 0;
        if (message instanceof PUnion) {
            PField<?> field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeFieldValue(out, field.getKey(), field.getDescriptor(), message.get(field.getKey()));
            }
        }
        return len + out.writeVarint(0);
    }

    private <T extends PMessage<T>> T readMessage(BinaryReader in, PStructDescriptor<T, ?> descriptor) throws PSerializeException, IOException {
        int tag;
        PBuilder builder = ((PMessageBuilderFactory)descriptor.factory()).builder();
        while ((tag = in.readIntVarint()) > 0) {
            int id = tag >>> 3;
            int type = tag & 7;
            Object field = descriptor.getField(id);
            if (field != null) {
                Object value = this.readFieldValue(in, type, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
                continue;
            }
            if (this.readStrict) {
                throw new PSerializeException("Unknown field " + id + " for type" + descriptor.getQualifiedName(null), new Object[0]);
            }
            this.readFieldValue(in, tag, null);
        }
        return (T)((PMessage)builder.build());
    }

    private int writeFieldValue(BinaryWriter out, int key, PDescriptor<?> descriptor, Object value) throws IOException, PSerializeException {
        switch (descriptor.getType()) {
            case BOOL: {
                return out.writeVarint(key << 3 | ((Boolean)value != false ? 1 : 0));
            }
            case BYTE: {
                int len = out.writeVarint(key << 3 | 2);
                return len + out.writeZigzag((int)((Byte)value).byteValue());
            }
            case I16: {
                int len = out.writeVarint(key << 3 | 2);
                return len + out.writeZigzag((int)((Short)value).shortValue());
            }
            case I32: {
                int len = out.writeVarint(key << 3 | 2);
                return len + out.writeZigzag(((Integer)value).intValue());
            }
            case I64: {
                int len = out.writeVarint(key << 3 | 2);
                return len + out.writeZigzag(((Long)value).longValue());
            }
            case DOUBLE: {
                int len = out.writeVarint(key << 3 | 3);
                return len + out.writeDouble(((Double)value).doubleValue());
            }
            case STRING: {
                byte[] bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                int len = out.writeVarint(key << 3 | 4);
                out.write(bytes);
                return (len += out.writeVarint(bytes.length)) + bytes.length;
            }
            case BINARY: {
                Binary bytes = (Binary)value;
                int len = out.writeVarint(key << 3 | 4);
                bytes.write((OutputStream)out);
                return (len += out.writeVarint(bytes.length())) + bytes.length();
            }
            case ENUM: {
                int len = out.writeVarint(key << 3 | 2);
                return len + out.writeZigzag(((PEnumValue)value).getValue());
            }
            case MESSAGE: {
                int len = out.writeVarint(key << 3 | 5);
                return len + this.writeMessage(out, (PMessage)value);
            }
            case MAP: {
                int len = out.writeVarint(key << 3 | 6);
                Map map = (Map)value;
                PMap desc = (PMap)descriptor;
                len += out.writeVarint(map.size() * 2);
                for (Map.Entry entry : map.entrySet()) {
                    len += this.writeFieldValue(out, 1, desc.keyDescriptor(), entry.getKey());
                    len += this.writeFieldValue(out, 2, desc.itemDescriptor(), entry.getValue());
                }
                return len;
            }
            case SET: 
            case LIST: {
                int len = out.writeVarint(key << 3 | 6);
                Collection coll = (Collection)value;
                PContainer desc = (PContainer)descriptor;
                len += out.writeVarint(coll.size());
                for (Object item : coll) {
                    len += this.writeFieldValue(out, 0, desc.itemDescriptor(), item);
                }
                return len;
            }
        }
        throw new PSerializeException("", new Object[0]);
    }

    protected <T> T readFieldValue(BinaryReader in, int type, PDescriptor<T> descriptor) throws IOException, PSerializeException {
        switch (type) {
            case 2: {
                if (descriptor == null) {
                    if (this.readStrict) {
                        throw new PSerializeException("", new Object[0]);
                    }
                    in.readLongVarint();
                    return null;
                }
                switch (descriptor.getType()) {
                    case BYTE: {
                        return this.cast((byte)in.readIntZigzag());
                    }
                    case I16: {
                        return this.cast((short)in.readIntZigzag());
                    }
                    case I32: {
                        return this.cast(in.readIntZigzag());
                    }
                    case I64: {
                        return this.cast(in.readLongZigzag());
                    }
                    case ENUM: {
                        PBuilder builder = ((PEnumBuilderFactory)((PEnumDescriptor)descriptor).factory()).builder();
                        ((PEnumBuilder)builder).setByValue(in.readIntZigzag());
                        return this.cast(builder.build());
                    }
                }
                throw new PSerializeException("", new Object[0]);
            }
            case 3: {
                return this.cast(in.expectDouble());
            }
            case 4: {
                int len = in.readIntVarint();
                byte[] data = in.expectBytes(len);
                if (descriptor != null) {
                    switch (descriptor.getType()) {
                        case STRING: {
                            return this.cast(new String(data, StandardCharsets.UTF_8));
                        }
                        case BINARY: {
                            return this.cast(Binary.wrap((byte[])data));
                        }
                    }
                    throw new PSerializeException("", new Object[0]);
                }
                if (this.readStrict) {
                    throw new PSerializeException("", new Object[0]);
                }
                return null;
            }
            case 5: {
                return this.cast(this.readMessage(in, (PStructDescriptor)descriptor));
            }
            case 6: {
                if (descriptor == null) {
                    if (this.readStrict) {
                        throw new PSerializeException("", new Object[0]);
                    }
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        this.readFieldValue(in, in.readIntVarint() & 7, null);
                    }
                    return null;
                }
                if (descriptor.getType() == PType.MAP) {
                    PMap ct = (PMap)descriptor;
                    PDescriptor kt = ct.keyDescriptor();
                    PDescriptor vt = ct.itemDescriptor();
                    LinkedHashMap out = new LinkedHashMap();
                    int len = in.readIntVarint();
                    for (int i = 0; i < len; ++i) {
                        Object key = this.readFieldValue(in, in.readIntVarint() & 7, kt);
                        Object value = this.readFieldValue(in, in.readIntVarint() & 7, vt);
                        out.put(key, value);
                        ++i;
                    }
                    return this.cast(out);
                }
                PContainer ct = (PContainer)descriptor;
                PDescriptor it = ct.itemDescriptor();
                AbstractCollection out = descriptor.getType() == PType.SET ? new LinkedHashSet() : new LinkedList();
                int len = in.readIntVarint();
                for (int i = 0; i < len; ++i) {
                    int tag = in.readIntVarint();
                    out.add(this.readFieldValue(in, tag & 7, it));
                }
                return this.cast(out);
            }
            case 0: {
                return this.cast(false);
            }
            case 1: {
                return this.cast(true);
            }
        }
        return null;
    }
}

