/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PSerializeException;
import net.morimekta.providence.serializer.PSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class PBinarySerializer
extends PSerializer {
    private final boolean mStrict;

    public PBinarySerializer() {
        this(true);
    }

    public PBinarySerializer(boolean strict) {
        this.mStrict = strict;
    }

    @Override
    public int serialize(OutputStream output, PMessage<?> message) throws IOException, PSerializeException {
        BinaryWriter writer = new BinaryWriter(output);
        int len = 0;
        if (message instanceof PUnion) {
            PField<?> field = ((PUnion)message).unionField();
            if (field != null) {
                len += writer.writeUInt16(field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()));
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += writer.writeUInt16(field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()));
            }
        }
        return len += writer.writeUInt16(0);
    }

    @Override
    public <T> int serialize(OutputStream output, PDescriptor<T> descriptor, T value) throws IOException, PSerializeException {
        try {
            if (descriptor.getType().equals((Object)PType.MESSAGE)) {
                return this.serialize(output, (PMessage)value);
            }
            BinaryWriter writer = new BinaryWriter(output);
            return this.writeFieldValue(writer, value);
        }
        catch (IOException e) {
            throw new PSerializeException(e, "Unable to write to stream", new Object[0]);
        }
    }

    @Override
    public <T> T deserialize(InputStream input, PDescriptor<T> descriptor) throws PSerializeException, IOException {
        BinaryReader reader = new BinaryReader(input);
        if (PType.MESSAGE == descriptor.getType()) {
            return this.cast(this.readMessage(reader, (PStructDescriptor)descriptor, true));
        }
        FieldInfo info = this.readFieldInfo(reader);
        if (info == null) {
            throw new PSerializeException("Unexpected end of stream.", new Object[0]);
        }
        return this.readFieldValue(reader, info, descriptor);
    }

    private <T extends PMessage<T>> T readMessage(BinaryReader input, PStructDescriptor<T, ?> descriptor, boolean nullable) throws PSerializeException, IOException {
        PBuilder builder = ((PMessageBuilderFactory)descriptor.factory()).builder();
        FieldInfo fieldInfo = this.readFieldInfo(input);
        if (nullable && fieldInfo == null) {
            return null;
        }
        while (fieldInfo != null) {
            Object field = descriptor.getField(fieldInfo.getId());
            if (field != null) {
                Object value = this.readFieldValue(input, fieldInfo, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
            } else {
                if (this.mStrict) {
                    throw new PSerializeException("Unknown field " + fieldInfo.getId() + " for type" + descriptor.getQualifiedName(null), new Object[0]);
                }
                this.readFieldValue(input, fieldInfo, null);
            }
            fieldInfo = this.readFieldInfo(input);
        }
        return (T)((PMessage)builder.build());
    }

    protected void consumeMessage(BinaryReader in) throws IOException, PSerializeException {
        FieldInfo fieldInfo;
        while ((fieldInfo = this.readFieldInfo(in)) != null) {
            this.readFieldValue(in, fieldInfo, null);
        }
    }

    protected FieldInfo readFieldInfo(BinaryReader in) throws IOException, PSerializeException {
        int id = in.readUInt16();
        if (id == 0) {
            return null;
        }
        int type_and_flag = in.expectUInt8();
        if (type_and_flag < 16) {
            throw new PSerializeException(String.format("No type on field", id), new Object[0]);
        }
        return new FieldInfo(id, type_and_flag);
    }

    protected FieldInfo readEntryFieldInfo(BinaryReader in, int fieldId) throws IOException, PSerializeException {
        int type_and_flag = in.expectUInt8();
        if (type_and_flag < 16) {
            throw new PSerializeException("No type on entry.", new Object[0]);
        }
        return new FieldInfo(fieldId, type_and_flag);
    }

    protected <T> T readFieldValue(BinaryReader in, FieldInfo fieldInfo, PDescriptor<T> type) throws IOException, PSerializeException {
        switch (fieldInfo.getType()) {
            case 16: {
                if (type != null) {
                    switch (type.getType()) {
                        case BOOL: {
                            return this.cast(fieldInfo.getBooleanValue());
                        }
                        case BYTE: {
                            return this.cast((byte)fieldInfo.getIntegerValue());
                        }
                        case I16: {
                            return this.cast((short)fieldInfo.getIntegerValue());
                        }
                        case I32: {
                            return this.cast(fieldInfo.getIntegerValue());
                        }
                        case I64: {
                            return this.cast(fieldInfo.getIntegerValue());
                        }
                        case DOUBLE: {
                            return this.cast(fieldInfo.getIntegerValue());
                        }
                    }
                    throw new PSerializeException("invalid type to parse boolean value: " + type.getName(), new Object[0]);
                }
                return null;
            }
            case 32: {
                Long number = in.expectSigned(fieldInfo.getNumericBytes());
                if (type != null) {
                    switch (type.getType()) {
                        case BYTE: {
                            return this.cast(number.byteValue());
                        }
                        case I16: {
                            return this.cast(number.shortValue());
                        }
                        case I32: {
                            return this.cast(number.intValue());
                        }
                        case I64: {
                            return this.cast(number);
                        }
                        case ENUM: {
                            PEnumDescriptor et = (PEnumDescriptor)type;
                            PEnumBuilder builder = ((PEnumBuilder)((PEnumBuilderFactory)et.factory()).builder()).setByValue(number.intValue());
                            if (this.mStrict && !builder.isValid()) {
                                throw new PSerializeException(number + " is not a valid " + type.getQualifiedName(null) + " enum value.", new Object[0]);
                            }
                            return this.cast(builder.build());
                        }
                    }
                    throw new PSerializeException("invalid type for numeric value " + type, new Object[0]);
                }
                return null;
            }
            case 48: {
                return this.cast(in.expectDouble());
            }
            case 64: {
                int bytes = fieldInfo.getArrayLengthBytes();
                int length = in.expectUnsigned(bytes);
                byte[] binary = in.expectBytes(length);
                if (type != null) {
                    switch (type.getType()) {
                        case BINARY: {
                            return this.cast(Binary.wrap((byte[])binary));
                        }
                        case STRING: {
                            return this.cast(new String(binary, StandardCharsets.UTF_8));
                        }
                    }
                    throw new PSerializeException("Illegal type for binary encoding: " + type, new Object[0]);
                }
                return null;
            }
            case 80: {
                if (type != null) {
                    if (!type.getType().equals((Object)PType.MESSAGE)) {
                        throw new PSerializeException("Invalid type for message encoding: " + type, new Object[0]);
                    }
                    return this.cast(this.readMessage(in, (PStructDescriptor)type, false));
                }
                this.consumeMessage(in);
                return null;
            }
            case 112: {
                PDescriptor keyType = null;
                PDescriptor valueType = null;
                if (type != null) {
                    if (!type.getType().equals((Object)PType.MAP)) {
                        throw new PSerializeException("Invalid type for map encoding: " + type, new Object[0]);
                    }
                    PMap mapType = (PMap)type;
                    keyType = mapType.keyDescriptor();
                    valueType = mapType.itemDescriptor();
                }
                int lb = fieldInfo.getArrayLengthBytes();
                int size = in.expectUnsigned(lb);
                LinkedHashMap out = new LinkedHashMap(size);
                for (int i = 0; i < size; ++i) {
                    FieldInfo entryInfo = this.readEntryFieldInfo(in, fieldInfo.getId());
                    if (entryInfo == null) {
                        throw new PSerializeException("Unexpected end of map stream.", new Object[0]);
                    }
                    Object key = this.readFieldValue(in, entryInfo, keyType);
                    entryInfo = this.readEntryFieldInfo(in, fieldInfo.getId());
                    if (entryInfo == null) {
                        throw new PSerializeException("Unexpected end of map stream.", new Object[0]);
                    }
                    Object value = this.readFieldValue(in, entryInfo, valueType);
                    if (key != null && value != null) {
                        out.put(key, value);
                        continue;
                    }
                    if (!this.mStrict) continue;
                    throw new PSerializeException("Null key or value in map.", new Object[0]);
                }
                return this.cast(out);
            }
            case 96: {
                PDescriptor entryType = null;
                if (type != null) {
                    if (!type.getType().equals((Object)PType.LIST) && !type.getType().equals((Object)PType.SET)) {
                        throw new PSerializeException("Invalid type for list encoding: " + type, new Object[0]);
                    }
                    entryType = ((PContainer)type).itemDescriptor();
                }
                int lb = fieldInfo.getArrayLengthBytes();
                int size = in.expectUnsigned(lb);
                AbstractCollection out = type.getType().equals((Object)PType.LIST) ? new LinkedList() : new LinkedHashSet(size);
                for (int i = 0; i < size; ++i) {
                    FieldInfo entryInfo = this.readEntryFieldInfo(in, fieldInfo.getId());
                    if (entryInfo == null) {
                        throw new PSerializeException("Unexpected end of collection.", new Object[0]);
                    }
                    Object key = this.readFieldValue(in, entryInfo, entryType);
                    if (key != null) {
                        out.add(key);
                        continue;
                    }
                    if (!this.mStrict) continue;
                    throw new PSerializeException("Null value in collection.", new Object[0]);
                }
                return this.cast(out);
            }
        }
        throw new PSerializeException("unknown data type: " + fieldInfo.getType(), new Object[0]);
    }

    protected int writeFieldValue(BinaryWriter out, Object value) throws IOException, PSerializeException {
        if (value instanceof PMessage) {
            int flags = 80;
            out.write(flags);
            return 1 + this.serialize((OutputStream)out, (PMessage)value);
        }
        if (value instanceof Boolean) {
            int flags = 0x10 | ((Boolean)value != false ? 1 : 0);
            out.write(flags);
            return 1;
        }
        if (value instanceof Binary) {
            return this.writeBinary(out, (Binary)value);
        }
        if (value instanceof String) {
            return this.writeBinary(out, Binary.wrap((byte[])((String)value).getBytes(StandardCharsets.UTF_8)));
        }
        if (value instanceof Double) {
            return this.writeDouble(out, (Double)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            int lengthBytes = this.getArrayLengthBytes(map.size());
            int flags = 0x70 | lengthBytes - 1;
            out.write(flags);
            int len = 1 + out.writeUnsigned(map.size(), lengthBytes);
            for (Map.Entry entry : map.entrySet()) {
                len += this.writeFieldValue(out, entry.getKey());
                len += this.writeFieldValue(out, entry.getValue());
            }
            return len;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int lengthBytes = this.getArrayLengthBytes(coll.size());
            int flags = 0x60 | lengthBytes - 1;
            out.write(flags);
            int len = 1 + out.writeUnsigned(coll.size(), lengthBytes);
            for (Object item : (Collection)value) {
                len += this.writeFieldValue(out, item);
            }
            return len;
        }
        if (value instanceof Byte) {
            byte number = (Byte)value;
            out.write(0x20 | this.getNumericByteLengthFlag(number));
            return 1 + out.writeSigned((int)number, this.getNumericByteLength(number));
        }
        if (value instanceof Short) {
            short number = (Short)value;
            out.write(0x20 | this.getNumericByteLengthFlag(number));
            return 1 + out.writeSigned((int)number, this.getNumericByteLength(number));
        }
        if (value instanceof Integer) {
            int number = (Integer)value;
            out.write(0x20 | this.getNumericByteLengthFlag(number));
            return 1 + out.writeSigned(number, this.getNumericByteLength(number));
        }
        if (value instanceof Long) {
            long number = (Long)value;
            out.write(0x20 | this.getNumericByteLengthFlag(number));
            return 1 + out.writeSigned(number, this.getNumericByteLength(number));
        }
        if (value instanceof PEnumValue) {
            int number = ((PEnumValue)value).getValue();
            out.write(0x20 | this.getNumericByteLengthFlag(number));
            return 1 + out.writeSigned(number, this.getNumericByteLength(number));
        }
        throw new PSerializeException("", new Object[0]);
    }

    protected int writeDouble(BinaryWriter out, double value) throws IOException {
        int flags = 48;
        out.write(flags);
        return 1 + out.writeDouble(value);
    }

    protected int writeBinary(BinaryWriter out, Binary bytes) throws IOException {
        int lengthBytes = this.getArrayLengthBytes(bytes.length());
        int flags = 0x40 | lengthBytes - 1 & 3;
        out.write(flags);
        out.writeUnsigned(bytes.length(), lengthBytes);
        bytes.write((OutputStream)out);
        return 1 + lengthBytes + bytes.length();
    }

    protected int getArrayLengthBytes(int length) {
        if (length >= 0xFFFFFF) {
            return 4;
        }
        if (length >= 65535) {
            return 3;
        }
        if (length >= 255) {
            return 2;
        }
        return 1;
    }

    protected int getNumericByteLength(long value) {
        if (value > Integer.MAX_VALUE) {
            return 8;
        }
        if (value > 32767L) {
            return 4;
        }
        if (value > 127L) {
            return 2;
        }
        if (value < Integer.MIN_VALUE) {
            return 8;
        }
        if (value < -32768L) {
            return 4;
        }
        if (value < -128L) {
            return 2;
        }
        return 1;
    }

    protected int getNumericByteLengthFlag(long value) {
        if (value > Integer.MAX_VALUE) {
            return 3;
        }
        if (value > 32767L) {
            return 2;
        }
        if (value > 127L) {
            return 1;
        }
        if (value < Integer.MIN_VALUE) {
            return 3;
        }
        if (value < -32768L) {
            return 2;
        }
        if (value < -128L) {
            return 1;
        }
        return 0;
    }

    protected static class FieldInfo {
        private final int id;
        private final int type;
        private final int flag;
        public static final int FIXED_8 = 0;
        public static final int FIXED_16 = 1;
        public static final int FIXED_32 = 2;
        public static final int FIXED_64 = 3;
        public static final int TRUE = 1;
        public static final int FALSE = 0;

        public FieldInfo(int id, int flags) {
            this.id = id;
            this.type = flags & 0xF0;
            this.flag = flags & 0xF;
        }

        public String toString() {
            return String.format("field(%d: %1x, %1x)", this.id, this.type >> 4, this.flag);
        }

        public int getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public boolean getBooleanValue() {
            return (this.flag & 1) != 0;
        }

        public int getIntegerValue() {
            return this.flag;
        }

        public int getArrayLengthBytes() {
            return (this.flag & 3) + 1;
        }

        public int getNumericBytes() throws PSerializeException {
            switch (this.flag & 3) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 8;
                }
            }
            throw new PSerializeException("OOPS", new Object[0]);
        }
    }

    protected static interface DataType {
        public static final int BOOLEAN = 16;
        public static final int INTEGER = 32;
        public static final int DOUBLE = 48;
        public static final int BINARY = 64;
        public static final int MESSAGE = 80;
        public static final int COLLECTION = 96;
        public static final int MAP = 112;
    }
}

