/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PField;

public abstract class PStructDescriptor<T extends PMessage<T>, F extends PField>
extends PDeclaredDescriptor<T> {
    private final PMessageBuilderFactory<T> mProvider;
    private final boolean mCompactible;
    private final boolean mSimple;

    public PStructDescriptor(String comment, String packageName, String name, PMessageBuilderFactory<T> provider, boolean simple, boolean compactible) {
        super(comment, packageName, name);
        this.mProvider = provider;
        this.mSimple = simple;
        this.mCompactible = compactible;
    }

    public abstract F[] getFields();

    public abstract F getField(String var1);

    public abstract F getField(int var1);

    public boolean isCompactible() {
        return this.mCompactible;
    }

    public boolean isSimple() {
        return this.mSimple;
    }

    public PMessageVariant getVariant() {
        return PMessageVariant.STRUCT;
    }

    @Override
    public PType getType() {
        return PType.MESSAGE;
    }

    @Override
    public PMessageBuilderFactory<T> factory() {
        return this.mProvider;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PStructDescriptor)) {
            return false;
        }
        PStructDescriptor other = (PStructDescriptor)o;
        if (!this.getQualifiedName(null).equals(other.getQualifiedName(null)) || !this.getVariant().equals((Object)other.getVariant()) || this.getFields().length != other.getFields().length) {
            return false;
        }
        for (PField field : this.getFields()) {
            if (field.equals(other.getField(field.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = PStructDescriptor.class.hashCode() + this.getQualifiedName(null).hashCode() + this.getVariant().hashCode();
        for (PField field : this.getFields()) {
            hash += field.hashCode();
        }
        return hash;
    }
}

