/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Objects;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PPrimitiveProvider;
import net.morimekta.util.Binary;

public class PPrimitive<T>
implements PDescriptor<T> {
    public static final PPrimitive<Void> VOID = new PPrimitive<Object>(PType.VOID, null);
    public static final PPrimitive<Boolean> BOOL = new PPrimitive<Boolean>(PType.BOOL, false);
    public static final PPrimitive<Byte> BYTE = new PPrimitive<Byte>(PType.BYTE, (byte)0);
    public static final PPrimitive<Short> I16 = new PPrimitive<Short>(PType.I16, (short)0);
    public static final PPrimitive<Integer> I32 = new PPrimitive<Integer>(PType.I32, 0);
    public static final PPrimitive<Long> I64 = new PPrimitive<Long>(PType.I64, 0L);
    public static final PPrimitive<Double> DOUBLE = new PPrimitive<Double>(PType.DOUBLE, 0.0);
    public static final PPrimitive<String> STRING = new PPrimitive<Object>(PType.STRING, null);
    public static final PPrimitive<Binary> BINARY = new PPrimitive<Object>(PType.BINARY, null);
    private final PPrimitiveProvider<T> mProvider;
    private final PType mType;
    private final T mDefault;

    private PPrimitive(PType type, T defValue) {
        this.mType = type;
        this.mProvider = new PPrimitiveProvider(this);
        this.mDefault = defValue;
    }

    public PPrimitiveProvider<T> provider() {
        return this.mProvider;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public String getName() {
        return this.mType.name;
    }

    @Override
    public String getQualifiedName(String packageName) {
        return this.mType.name;
    }

    public String toString() {
        return this.mType.name;
    }

    @Override
    public PType getType() {
        return this.mType;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mType, this.mDefault});
    }

    public T getDefaultValue() {
        return this.mDefault;
    }

    public static PPrimitive<?> findByName(String name) {
        switch (name) {
            case "void": {
                return VOID;
            }
            case "bool": {
                return BOOL;
            }
            case "byte": {
                return BYTE;
            }
            case "i16": {
                return I16;
            }
            case "i32": {
                return I32;
            }
            case "i64": {
                return I64;
            }
            case "double": {
                return DOUBLE;
            }
            case "string": {
                return STRING;
            }
            case "binary": {
                return BINARY;
            }
        }
        return null;
    }
}

