/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.descriptor;

import java.util.Map;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PContainerProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;

public class PMap<K, V>
extends PContainer<V, Map<K, V>> {
    private final PDescriptorProvider<K> mKeyDescriptor;

    public PMap(PDescriptorProvider<K> keyDesc, PDescriptorProvider<V> itemDesc) {
        super(itemDesc);
        this.mKeyDescriptor = keyDesc;
    }

    public PDescriptor<K> keyDescriptor() {
        return this.mKeyDescriptor.descriptor();
    }

    @Override
    public String getName() {
        return "map<" + this.keyDescriptor().getName() + "," + this.itemDescriptor().getName() + ">";
    }

    @Override
    public String getQualifiedName(String packageName) {
        return "map<" + this.keyDescriptor().getQualifiedName(packageName) + "," + this.itemDescriptor().getQualifiedName(packageName) + ">";
    }

    @Override
    public PType getType() {
        return PType.MAP;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PMap)) {
            return false;
        }
        PMap other = (PMap)o;
        return other.itemDescriptor().equals(this.itemDescriptor()) && other.keyDescriptor().equals(this.keyDescriptor());
    }

    public int hashCode() {
        return PMap.class.hashCode() + this.itemDescriptor().hashCode() + this.keyDescriptor().hashCode();
    }

    public static <K, V> PContainerProvider<V, Map<K, V>, PMap<K, V>> provider(PDescriptorProvider<K> keyDesc, PDescriptorProvider<V> itemDesc) {
        return new PContainerProvider(new PMap<K, V>(keyDesc, itemDesc));
    }
}

