/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.streams;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PFastBinarySerializer;
import net.morimekta.providence.serializer.PJsonSerializer;
import net.morimekta.providence.serializer.PSerializeException;
import net.morimekta.providence.serializer.PSerializer;
import net.morimekta.util.io.IOUtils;

public class MessageStreams {
    public static <T extends PMessage<T>, F extends PField> Stream<T> file(File file, PStructDescriptor<T, F> descriptor) throws IOException {
        PJsonSerializer serializer;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        in.mark(16);
        int r = in.read();
        if (r < 0) {
            throw new IOException("Unexpected end of stream.");
        }
        if (r == PJsonSerializer.DEFAULT_STREAM_INITIATOR[0]) {
            serializer = new PJsonSerializer(true);
            in.reset();
        } else {
            serializer = new PFastBinarySerializer(true);
            in.reset();
        }
        return MessageStreams.stream(in, (PSerializer)serializer, descriptor);
    }

    public static <T extends PMessage<T>, F extends PField> Stream<T> file(File file, PSerializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        if (!serializer.streamInitiatorPartOfData()) {
            IOUtils.skipUntil((InputStream)in, (byte[])serializer.streamInitiator());
        }
        return StreamSupport.stream(new StreamMessageSpliterator(in, serializer, descriptor, is -> {
            try {
                is.close();
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), false);
    }

    public static <T extends PMessage<T>, F extends PField> Stream<T> resource(String resource, PSerializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        InputStream in = MessageStreams.class.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("No such resource " + resource);
        }
        return StreamSupport.stream(new StreamMessageSpliterator(new BufferedInputStream(in), serializer, descriptor, is -> {
            try {
                is.close();
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), false);
    }

    public static <T extends PMessage<T>, F extends PField> Stream<T> stream(InputStream in, PSerializer serializer, PStructDescriptor<T, F> descriptor) throws IOException {
        return StreamSupport.stream(new StreamMessageSpliterator(in, serializer, descriptor, null), false);
    }

    private static class StreamMessageSpliterator<T extends PMessage<T>, F extends PField>
    extends BaseMessageSpliterator<T> {
        private final InputStream in;
        private final PStructDescriptor<T, F> descriptor;
        private final PSerializer serializer;
        private int num;
        private Function<InputStream, Void> closer;

        private StreamMessageSpliterator(InputStream in, PSerializer serializer, PStructDescriptor<T, F> descriptor, Function<InputStream, Void> closer) throws IOException {
            this.in = in;
            this.closer = closer;
            this.serializer = serializer;
            this.descriptor = descriptor;
            this.num = 0;
        }

        @Override
        public T read() {
            try {
                PMessage out;
                if (this.num > 0 && !IOUtils.skipUntil((InputStream)this.in, (byte[])this.serializer.entrySeparator())) {
                    this.close();
                    T t = null;
                    return t;
                }
                if (this.in.markSupported()) {
                    this.in.mark(2);
                    if (this.in.read() < 0) {
                        T t = null;
                        return t;
                    }
                    this.in.reset();
                }
                if ((out = (PMessage)this.serializer.deserialize(this.in, this.descriptor)) == null) {
                    this.close();
                }
                PMessage pMessage = out;
                return (T)pMessage;
            }
            catch (PSerializeException e) {
                throw new UncheckedIOException(new IOException(e));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                ++this.num;
            }
        }

        protected void close() {
            if (this.closer != null) {
                try {
                    this.closer.apply(this.in);
                }
                finally {
                    this.closer = null;
                }
            }
        }
    }

    private static abstract class BaseMessageSpliterator<T extends PMessage<T>>
    implements Spliterator<T> {
        private BaseMessageSpliterator() {
        }

        protected abstract T read();

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            T message = this.read();
            if (message != null) {
                action.accept(message);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            T message;
            while ((message = this.read()) != null) {
                action.accept(message);
            }
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getExactSizeIfKnown() {
            return -1L;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return Comparable::compareTo;
        }
    }
}

