/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.ProvidenceHttpError;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedQualityCSV;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class ProvidenceErrorHandler
extends ErrorHandler {
    private final SerializerProvider provider;

    public ProvidenceErrorHandler() {
        this((SerializerProvider)new DefaultSerializerProvider());
    }

    public ProvidenceErrorHandler(@Nonnull SerializerProvider provider) {
        this.provider = provider;
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        List acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT, QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        for (String accept : acceptable) {
            try {
                this.sendResponse(this.provider.getSerializer(accept), response, code, message);
                return;
            }
            catch (Exception exception) {
            }
        }
        String contentType = request.getHeader(HttpHeader.CONTENT_TYPE.toString());
        if (contentType != null) {
            try {
                this.sendResponse(this.provider.getSerializer(contentType), response, code, message);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sendResponse(this.provider.getDefault(), response, code, message);
    }

    protected void generateAcceptableResponse(Request baseRequest, HttpServletRequest request, HttpServletResponse response, int code, String message, String mimeType) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        List acceptable = baseRequest.getHttpFields().getQualityCSV(HttpHeader.ACCEPT, QuotedQualityCSV.MOST_SPECIFIC_MIME_ORDERING);
        for (String accept : acceptable) {
            try {
                this.sendResponse(this.provider.getSerializer(accept), response, code, message);
                return;
            }
            catch (Exception exception) {
            }
        }
        String contentType = request.getHeader(HttpHeader.CONTENT_TYPE.toString());
        if (contentType != null) {
            try {
                this.sendResponse(this.provider.getSerializer(contentType), response, code, message);
                return;
            }
            catch (Exception accept) {
                // empty catch block
            }
        }
        try {
            this.sendResponse(this.provider.getSerializer(mimeType), response, code, message);
        }
        catch (Exception e) {
            this.sendResponse(this.provider.getDefault(), response, code, message);
        }
    }

    private void sendResponse(Serializer serializer, HttpServletResponse response, int code, String message) throws IOException {
        response.setStatus(code);
        serializer.serialize((OutputStream)response.getOutputStream(), (PMessageOrBuilder)ProvidenceHttpError.builder().setStatusCode(code).setMessage(message).build());
    }
}

