/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.ProcessorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceServlet.class);
    private final ProcessorProvider processorProvider;
    private final SerializerProvider serializerProvider;
    private final PServiceCallInstrumentation instrumentation;
    private final boolean sizedOutput;

    public ProvidenceServlet(@Nonnull PProcessor processor) {
        this(processor, (SerializerProvider)DefaultSerializerProvider.INSTANCE);
    }

    public ProvidenceServlet(@Nonnull PProcessor processor, @Nonnull SerializerProvider serializerProvider) {
        this((HttpServletRequest r) -> processor, serializerProvider);
    }

    public ProvidenceServlet(@Nonnull PProcessor processor, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation) {
        this(r -> processor, serializerProvider, instrumentation, true);
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider) {
        this(processorProvider, (SerializerProvider)DefaultSerializerProvider.INSTANCE, PServiceCallInstrumentation.NOOP);
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider, @Nonnull SerializerProvider serializerProvider) {
        this(processorProvider, serializerProvider, PServiceCallInstrumentation.NOOP);
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation) {
        this(processorProvider, serializerProvider, instrumentation, true);
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation, boolean sizedOutput) {
        this.processorProvider = processorProvider;
        this.serializerProvider = serializerProvider;
        this.instrumentation = instrumentation;
        this.sizedOutput = sizedOutput;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        long startTime = System.nanoTime();
        PServiceCall request = null;
        PServiceCall response = null;
        try {
            PProcessor processor = this.processorProvider.processorForRequest(req);
            Serializer requestSerializer = this.serializerProvider.getDefault();
            if (req.getContentType() != null) {
                try {
                    requestSerializer = this.serializerProvider.getSerializer(req.getContentType());
                }
                catch (IllegalArgumentException e) {
                    resp.sendError(400, "Unknown content-type: " + req.getContentType());
                    LOGGER.warn("Unknown content type in request", (Throwable)e);
                    return;
                }
            } else {
                LOGGER.debug("Request is missing content type.");
            }
            Serializer responseSerializer = requestSerializer;
            String acceptHeader = req.getHeader("Accept");
            if (acceptHeader != null) {
                String[] entries = acceptHeader.split(",");
                for (String entry : entries) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    if ("*/*".equals(entry)) break;
                    try {
                        responseSerializer = this.serializerProvider.getSerializer(entry);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            try {
                ServletInputStream in = req.getInputStream();
                Object object = null;
                try {
                    request = requestSerializer.deserialize((InputStream)in, processor.getDescriptor());
                    requestSerializer.verifyEndOfContent((InputStream)in);
                    if (request.getType() == PServiceCallType.REPLY || request.getType() == PServiceCallType.EXCEPTION) {
                        PApplicationException ex = new PApplicationException("Invalid service request call type: " + request.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                        response = new PServiceCall(request.getMethod(), PServiceCallType.EXCEPTION, request.getSequence(), (PMessage)ex);
                    } else {
                        response = processor.handleCall(request);
                    }
                }
                catch (Throwable ex) {
                    object = ex;
                    throw ex;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable ex) {
                                ((Throwable)object).addSuppressed(ex);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (SerializerException e) {
                if (e.getMethodName() != null) {
                    LOGGER.error("Error when reading service call " + processor.getDescriptor().getName() + "." + e.getMethodName() + "()", (Throwable)e);
                } else {
                    LOGGER.error("Error when reading service call " + processor.getDescriptor().getName(), (Throwable)e);
                }
                PApplicationException ex = new PApplicationException(e.getMessage(), e.getExceptionType()).initCause((Throwable)e);
                response = new PServiceCall(e.getMethodName(), PServiceCallType.EXCEPTION, e.getSequenceNo(), (PMessage)ex);
            }
            resp.setStatus(200);
            if (response != null) {
                resp.setContentType(responseSerializer.mediaType());
                if (this.sizedOutput) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    responseSerializer.serialize((OutputStream)baos, response);
                    resp.setContentLength(baos.size());
                    resp.getOutputStream().write(baos.toByteArray());
                } else {
                    responseSerializer.serialize((OutputStream)resp.getOutputStream(), response);
                }
            }
            resp.flushBuffer();
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onComplete(duration, request, response);
            }
            catch (Exception th) {
                LOGGER.error("Exception in service instrumentation", (Throwable)th);
            }
        }
        catch (EOFException e) {
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException((Exception)e, duration, request, response);
            }
            catch (Exception th) {
                LOGGER.error("Exception in service instrumentation", (Throwable)th);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unhandled exception in {}", (Object)req.getPathInfo(), (Object)e);
            if (!resp.isCommitted()) {
                try {
                    resp.sendError(500, "Internal server error: " + e.getMessage());
                    resp.flushBuffer();
                }
                catch (IOException ioEx) {
                    e.addSuppressed(ioEx);
                }
            }
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException(e, duration, request, response);
            }
            catch (Exception th) {
                LOGGER.error("Exception in service instrumentation", (Throwable)th);
            }
        }
    }
}

