/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.providence.server.ProvidenceHttpError_OrBuilder;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class ProvidenceHttpError
extends Exception
implements ProvidenceHttpError_OrBuilder,
PMessage<ProvidenceHttpError>,
PException,
Comparable<ProvidenceHttpError>,
BinaryWriter {
    private static final int kDefaultStatusCode = 0;
    private static final long serialVersionUID = -8543316838990827604L;
    private final transient String mMessage;
    private final transient Integer mStatusCode;
    private volatile transient int tHashCode;
    private transient ProvidenceHttpError tSerializeInstance;
    public static final PExceptionDescriptor<ProvidenceHttpError> kDescriptor = new _Descriptor();

    private ProvidenceHttpError(_Builder builder) {
        super(builder.mMessage);
        this.mMessage = builder.mMessage;
        this.mStatusCode = builder.mStatusCode;
    }

    @Override
    public boolean hasMessage() {
        return this.mMessage != null;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    @Override
    @Nonnull
    public Optional<String> optionalMessage() {
        return Optional.ofNullable(this.mMessage);
    }

    @Override
    public boolean hasStatusCode() {
        return this.mStatusCode != null;
    }

    @Override
    public int getStatusCode() {
        return this.hasStatusCode() ? this.mStatusCode : 0;
    }

    @Override
    @Nonnull
    public Optional<Integer> optionalStatusCode() {
        return Optional.ofNullable(this.mStatusCode);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mMessage != null;
            }
            case 2: {
                return this.mStatusCode != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mMessage;
            }
            case 2: {
                return (T)this.mStatusCode;
            }
        }
        return null;
    }

    public String origGetMessage() {
        return super.getMessage();
    }

    public String origGetLocalizedMessage() {
        return super.getLocalizedMessage();
    }

    @Override
    public ProvidenceHttpError initCause(Throwable cause) {
        return (ProvidenceHttpError)super.initCause(cause);
    }

    @Override
    public ProvidenceHttpError fillInStackTrace() {
        return (ProvidenceHttpError)super.fillInStackTrace();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ProvidenceHttpError other = (ProvidenceHttpError)o;
        return Objects.equals(this.mMessage, other.mMessage) && Objects.equals(this.mStatusCode, other.mStatusCode);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ProvidenceHttpError.class, _Field.MESSAGE, this.mMessage, _Field.STATUS_CODE, this.mStatusCode});
        }
        return this.tHashCode;
    }

    @Override
    public String toString() {
        return "p_http.ProvidenceHttpError" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasMessage()) {
            first = false;
            out.append("message:").append('\"').append(Strings.escape((CharSequence)this.mMessage)).append('\"');
        }
        if (this.hasStatusCode()) {
            if (!first) {
                out.append(',');
            }
            out.append("status_code:").append(this.mStatusCode);
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ProvidenceHttpError other) {
        int c = Boolean.compare(this.mMessage != null, other.mMessage != null);
        if (c != 0) {
            return c;
        }
        if (this.mMessage != null && (c = this.mMessage.compareTo(other.mMessage)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mStatusCode != null, other.mStatusCode != null);
        if (c != 0) {
            return c;
        }
        if (this.mStatusCode != null && (c = Integer.compare(this.mStatusCode, other.mStatusCode)) != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer.INSTANCE.serialize((OutputStream)oos, (PMessageOrBuilder)this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tSerializeInstance = (ProvidenceHttpError)BinarySerializer.INSTANCE.deserialize((InputStream)ois, kDescriptor);
        if (this.getCause() != null) {
            this.tSerializeInstance.initCause(this.getCause());
        }
        this.tSerializeInstance.setStackTrace(this.getStackTrace());
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasMessage()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)1);
            Binary tmp_1 = Binary.wrap((byte[])this.mMessage.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        if (this.hasStatusCode()) {
            length += writer.writeByte((byte)8);
            length += writer.writeShort((short)2);
            length += writer.writeInt(this.mStatusCode.intValue());
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PExceptionDescriptorProvider<ProvidenceHttpError> provider() {
        return new _Provider();
    }

    @Nonnull
    public PExceptionDescriptor<ProvidenceHttpError> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ProvidenceHttpError>
    implements ProvidenceHttpError_OrBuilder,
    BinaryReader {
        private Throwable cause;
        private BitSet optionals = new BitSet(2);
        private BitSet modified = new BitSet(2);
        private String mMessage;
        private Integer mStatusCode;

        public _Builder() {
        }

        public _Builder(ProvidenceHttpError base) {
            this();
            if (base.hasMessage()) {
                this.optionals.set(0);
                this.mMessage = base.mMessage;
            }
            if (base.hasStatusCode()) {
                this.optionals.set(1);
                this.mStatusCode = base.mStatusCode;
            }
        }

        @Nonnull
        public _Builder merge(ProvidenceHttpError from) {
            if (from.hasMessage()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mMessage = from.getMessage();
            }
            if (from.hasStatusCode()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mStatusCode = from.getStatusCode();
            }
            return this;
        }

        @Nonnull
        public _Builder setMessage(String value) {
            if (value == null) {
                return this.clearMessage();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mMessage = value;
            return this;
        }

        public boolean isSetMessage() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasMessage() {
            return this.optionals.get(0);
        }

        public boolean isModifiedMessage() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearMessage() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mMessage = null;
            return this;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }

        @Override
        @Nonnull
        public Optional<String> optionalMessage() {
            return Optional.ofNullable(this.mMessage);
        }

        @Nonnull
        public _Builder setStatusCode(Integer value) {
            if (value == null) {
                return this.clearStatusCode();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mStatusCode = value;
            return this;
        }

        @Nonnull
        public _Builder setStatusCode(int value) {
            this.optionals.set(1);
            this.modified.set(1);
            this.mStatusCode = value;
            return this;
        }

        public boolean isSetStatusCode() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasStatusCode() {
            return this.optionals.get(1);
        }

        public boolean isModifiedStatusCode() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearStatusCode() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mStatusCode = null;
            return this;
        }

        @Override
        public int getStatusCode() {
            return this.isSetStatusCode() ? this.mStatusCode : 0;
        }

        @Override
        @Nonnull
        public Optional<Integer> optionalStatusCode() {
            return Optional.ofNullable(this.mStatusCode);
        }

        @Nonnull
        public _Builder initCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mMessage, other.mMessage) && Objects.equals(this.mStatusCode, other.mStatusCode);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{ProvidenceHttpError.class, this.optionals, _Field.MESSAGE, this.mMessage, _Field.STATUS_CODE, this.mStatusCode});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setMessage((String)value);
                    break;
                }
                case 2: {
                    this.setStatusCode((int)((Integer)value));
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)this.getMessage();
                }
                case 2: {
                    return (T)Integer.valueOf(this.getStatusCode());
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return this.mMessage != null;
                }
                case 2: {
                    return this.mStatusCode != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearMessage();
                    break;
                }
                case 2: {
                    this.clearStatusCode();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return true;
        }

        public _Builder validate() {
            return this;
        }

        @Nonnull
        public PExceptionDescriptor<ProvidenceHttpError> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mMessage = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for p_http.ProvidenceHttpError.message, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 8) {
                            this.mStatusCode = reader.expectInt();
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for p_http.ProvidenceHttpError.status_code, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public ProvidenceHttpError build() {
            ProvidenceHttpError e = new ProvidenceHttpError(this);
            try {
                StackTraceElement[] stackTrace = e.getStackTrace();
                StackTraceElement[] subTrace = new StackTraceElement[stackTrace.length - 1];
                System.arraycopy(stackTrace, 1, subTrace, 0, subTrace.length);
                e.setStackTrace(subTrace);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.cause != null) {
                e.initCause(this.cause);
            }
            return e;
        }
    }

    private static final class _Provider
    extends PExceptionDescriptorProvider<ProvidenceHttpError> {
        private _Provider() {
        }

        public PExceptionDescriptor<ProvidenceHttpError> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PExceptionDescriptor<ProvidenceHttpError> {
        public _Descriptor() {
            super("p_http", "ProvidenceHttpError", _Builder::new, true);
        }

        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<ProvidenceHttpError>
    {
        MESSAGE(1, PRequirement.OPTIONAL, "message", "message", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        STATUS_CODE(2, PRequirement.OPTIONAL, "status_code", "statusCode", (PDescriptorProvider)PPrimitive.I32.provider(), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, String pojoName, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mPojoName = pojoName;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        @Nonnull
        public String getPojoName() {
            return this.mPojoName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        @Nonnull
        public PMessageDescriptor<ProvidenceHttpError> onMessageType() {
            return kDescriptor;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return MESSAGE;
                }
                case 2: {
                    return STATUS_CODE;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "message": {
                    return MESSAGE;
                }
                case "status_code": {
                    return STATUS_CODE;
                }
            }
            return null;
        }

        public static _Field findByPojoName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "message": {
                    return MESSAGE;
                }
                case "statusCode": {
                    return STATUS_CODE;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in p_http.ProvidenceHttpError");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in p_http.ProvidenceHttpError");
            }
            return field;
        }

        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in p_http.ProvidenceHttpError");
            }
            return field;
        }
    }
}

