/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.ExceptionHandler;
import net.morimekta.providence.server.ProcessorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceHttpServletWrapper
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceHttpServletWrapper.class);
    private final SerializerProvider serializerProvider;
    private final ProcessorProvider processorProvider;
    private final Map<String, PServiceMethod> mapping;
    private final ExceptionHandler exceptionHandler;
    private final PServiceCallInstrumentation instrumentation;

    public ProvidenceHttpServletWrapper(@Nonnull PService service, @Nonnull ProcessorProvider processorProvider, ExceptionHandler exceptionHandler, SerializerProvider serializerProvider, PServiceCallInstrumentation instrumentation) {
        this(processorProvider, ProvidenceHttpServletWrapper.createMapping(service), exceptionHandler, serializerProvider, instrumentation);
    }

    public ProvidenceHttpServletWrapper(@Nonnull ProcessorProvider processorProvider, @Nonnull Map<String, PServiceMethod> mapping, ExceptionHandler exceptionHandler, SerializerProvider serializerProvider, PServiceCallInstrumentation instrumentation) {
        this.processorProvider = processorProvider;
        this.mapping = mapping;
        this.exceptionHandler = exceptionHandler == null ? ExceptionHandler.INSTANCE : exceptionHandler;
        this.serializerProvider = serializerProvider == null ? DefaultSerializerProvider.INSTANCE : serializerProvider;
        this.instrumentation = instrumentation == null ? PServiceCallInstrumentation.NOOP : instrumentation;
    }

    protected final void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        long start = System.nanoTime();
        try {
            PMessage response;
            PServiceCall handledCall;
            PServiceCall callToHandle;
            Serializer responseSerializer;
            block36: {
                PMessage request;
                PServiceMethod method;
                String path = httpRequest.getPathInfo();
                if (path == null) {
                    path = "/";
                }
                if (path.length() > 1 && path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((method = this.mapping.get(path)) == null) {
                    LOGGER.debug("No servlet for translated path {}", (Object)path);
                    httpResponse.sendError(404);
                    try {
                        PApplicationException ex = new PApplicationException("No servlet for translated path" + path, PApplicationExceptionType.UNKNOWN_METHOD);
                        this.instrumentation.onTransportException((Exception)ex, ProvidenceHttpServletWrapper.runTime(start), null, null);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return;
                }
                Serializer requestSerializer = this.serializerProvider.getDefault();
                if (httpRequest.getContentType() != null) {
                    try {
                        requestSerializer = this.serializerProvider.getSerializer(httpRequest.getContentType());
                    }
                    catch (IllegalArgumentException e) {
                        httpResponse.sendError(400, "Unknown content-type: " + httpRequest.getContentType());
                        LOGGER.warn("Unknown content type in request", (Throwable)e);
                        try {
                            PApplicationException ex = new PApplicationException("Unknown content-type: " + httpRequest.getContentType(), PApplicationExceptionType.INVALID_PROTOCOL);
                            this.instrumentation.onTransportException((Exception)ex, ProvidenceHttpServletWrapper.runTime(start), null, null);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        return;
                    }
                }
                LOGGER.debug("Request is missing content type.");
                responseSerializer = requestSerializer;
                String acceptHeader = httpRequest.getHeader("Accept");
                if (acceptHeader != null) {
                    String[] entries;
                    for (String entry : entries = acceptHeader.split(",")) {
                        if ((entry = entry.trim()).isEmpty()) continue;
                        if ("*/*".equals(entry)) break;
                        try {
                            MimeType mediaType = new MimeType(entry);
                            responseSerializer = this.serializerProvider.getSerializer(mediaType.getBaseType());
                            break;
                        }
                        catch (MimeTypeParseException mediaType) {
                            // empty catch block
                        }
                    }
                }
                try {
                    request = requestSerializer.deserialize((InputStream)httpRequest.getInputStream(), (PMessageDescriptor)method.getRequestType());
                    requestSerializer.verifyEndOfContent((InputStream)httpRequest.getInputStream());
                }
                catch (SerializerException e) {
                    LOGGER.info("Failed to deserialize request to {}: {}", new Object[]{httpRequest.getServletPath(), e.displayString(), e});
                    PApplicationException ex = new PApplicationException(e.getMessage(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
                    this.exceptionHandler.handleException(this.exceptionHandler.getResponseException((Throwable)ex), responseSerializer, httpRequest, httpResponse);
                    try {
                        this.instrumentation.onTransportException((Exception)ex, ProvidenceHttpServletWrapper.runTime(start), null, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                callToHandle = new PServiceCall(method.getName(), PServiceCallType.CALL, 1, request);
                handledCall = null;
                PProcessor processor = this.processorProvider.processorForRequest(httpRequest);
                try {
                    handledCall = processor.handleCall(callToHandle);
                    if (handledCall.getType() == PServiceCallType.EXCEPTION) {
                        throw (PApplicationException)handledCall.getMessage();
                    }
                    if (handledCall.getMessage().has(0)) {
                        Object responseMessage = handledCall.getMessage().get(0);
                        response = responseMessage instanceof PMessage ? (PMessage)responseMessage : handledCall.getMessage();
                        break block36;
                    }
                    PUnion responseUnion = (PUnion)handledCall.getMessage();
                    PException ex = (PException)responseUnion.get(responseUnion.unionField());
                    throw (Exception)ex;
                }
                catch (Exception e) {
                    block37: {
                        try {
                            this.exceptionHandler.handleException(this.exceptionHandler.getResponseException(e), responseSerializer, httpRequest, httpResponse);
                            if (!httpResponse.isCommitted()) {
                                httpResponse.sendError(500, e.getMessage());
                            }
                        }
                        catch (Exception e1) {
                            LOGGER.error("Exception sending error", (Throwable)e1);
                            if (httpResponse.isCommitted()) break block37;
                            httpResponse.sendError(500, e1.getMessage());
                        }
                    }
                    try {
                        this.instrumentation.onComplete(ProvidenceHttpServletWrapper.runTime(start), callToHandle, handledCall);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
            httpResponse.setStatus(200);
            httpResponse.setContentType(responseSerializer.mediaType());
            responseSerializer.serialize((OutputStream)httpResponse.getOutputStream(), (PMessageOrBuilder)response);
            httpResponse.flushBuffer();
            try {
                this.instrumentation.onComplete(ProvidenceHttpServletWrapper.runTime(start), callToHandle, handledCall);
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            try {
                this.instrumentation.onTransportException((Exception)e, ProvidenceHttpServletWrapper.runTime(start), null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Unhandled exception in {}", (Object)httpRequest.getPathInfo(), (Object)e);
            try {
                this.instrumentation.onTransportException(e, ProvidenceHttpServletWrapper.runTime(start), null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static double runTime(long startNano) {
        long endNano = System.nanoTime();
        return (double)(endNano - startNano) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
    }

    private static Map<String, PServiceMethod> createMapping(PService service) {
        HashMap<String, PServiceMethod> mapping = new HashMap<String, PServiceMethod>();
        for (PServiceMethod method : service.getMethods()) {
            mapping.put("/" + method.getName(), method);
        }
        return mapping;
    }
}

