/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProvidenceHttpServlet<RequestType extends PMessage<RequestType>, ResponseType extends PMessage<ResponseType>>
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceHttpServlet.class);
    private final PMessageDescriptor<RequestType> requestDescriptor;
    private final ExceptionHandler exceptionHandler;
    private final SerializerProvider serializerProvider;

    public ProvidenceHttpServlet(@Nonnull PMessageDescriptor<RequestType> requestDescriptor, @Nullable ExceptionHandler exceptionHandler, @Nullable SerializerProvider serializerProvider) {
        this.requestDescriptor = requestDescriptor;
        this.exceptionHandler = exceptionHandler == null ? ExceptionHandler.INSTANCE : exceptionHandler;
        this.serializerProvider = serializerProvider == null ? DefaultSerializerProvider.INSTANCE : serializerProvider;
    }

    @Nonnull
    protected abstract ResponseType handle(@Nonnull HttpServletRequest var1, @Nonnull RequestType var2) throws Exception;

    protected final void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        ResponseType response;
        PMessage request;
        Serializer requestSerializer = this.serializerProvider.getDefault();
        if (httpRequest.getContentType() != null) {
            try {
                requestSerializer = this.serializerProvider.getSerializer(httpRequest.getContentType());
            }
            catch (IllegalArgumentException e) {
                httpResponse.sendError(400, "Unknown content-type: " + httpRequest.getContentType());
                LOGGER.warn("Unknown content type in request", (Throwable)e);
                return;
            }
        } else {
            LOGGER.debug("Request is missing content type.");
        }
        Serializer responseSerializer = requestSerializer;
        String acceptHeader = httpRequest.getHeader("Accept");
        if (acceptHeader != null) {
            String[] entries;
            for (String entry : entries = acceptHeader.split(",")) {
                if ((entry = entry.trim()).isEmpty()) continue;
                if ("*/*".equals(entry)) break;
                try {
                    MimeType mediaType = new MimeType(entry);
                    responseSerializer = this.serializerProvider.getSerializer(mediaType.getBaseType());
                    break;
                }
                catch (MimeTypeParseException mimeTypeParseException) {
                    // empty catch block
                }
            }
        }
        try {
            request = requestSerializer.deserialize((InputStream)httpRequest.getInputStream(), this.requestDescriptor);
            requestSerializer.verifyEndOfContent((InputStream)httpRequest.getInputStream());
        }
        catch (SerializerException e) {
            LOGGER.info("Failed to deserialize request to {}: {}", new Object[]{httpRequest.getServletPath(), e.displayString(), e});
            PApplicationException ex = new PApplicationException(e.getMessage(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
            this.exceptionHandler.handleException((Throwable)ex, responseSerializer, httpRequest, httpResponse);
            return;
        }
        try {
            response = this.handle(httpRequest, request);
        }
        catch (Exception e) {
            block15: {
                try {
                    this.exceptionHandler.handleException(e, responseSerializer, httpRequest, httpResponse);
                    if (!httpResponse.isCommitted()) {
                        httpResponse.sendError(500, e.getMessage());
                    }
                }
                catch (Exception e1) {
                    LOGGER.error("Exception sending error", (Throwable)e1);
                    if (httpResponse.isCommitted()) break block15;
                    httpResponse.sendError(500, e1.getMessage());
                }
            }
            return;
        }
        httpResponse.setStatus(200);
        httpResponse.setContentType(responseSerializer.mediaType());
        responseSerializer.serialize((OutputStream)httpResponse.getOutputStream(), response);
        httpResponse.flushBuffer();
    }
}

