/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.serializer.Serializer;

public class ExceptionHandler {
    public static final ExceptionHandler INSTANCE = new ExceptionHandler();

    public void handleException(@Nonnull Throwable rex, @Nonnull Serializer responseSerializer, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws IOException {
        if ((rex = this.getResponseException(rex)) instanceof PMessageOrBuilder) {
            PMessageOrBuilder mex = (PMessageOrBuilder)rex;
            httpResponse.setStatus(this.statusCodeForException(rex));
            httpResponse.setContentType(responseSerializer.mediaType());
            responseSerializer.serialize((OutputStream)httpResponse.getOutputStream(), mex);
        } else {
            httpResponse.sendError(this.statusCodeForException(rex), rex.getMessage());
        }
        httpResponse.flushBuffer();
    }

    @Nonnull
    protected Throwable getResponseException(Throwable e) {
        return e;
    }

    protected int statusCodeForException(@Nonnull Throwable exception) {
        if (exception instanceof PApplicationException) {
            PApplicationException e = (PApplicationException)exception;
            if (e.getType() == PApplicationExceptionType.INVALID_PROTOCOL || e.getType() == PApplicationExceptionType.PROTOCOL_ERROR || e.getType() == PApplicationExceptionType.BAD_SEQUENCE_ID || e.getType() == PApplicationExceptionType.INVALID_MESSAGE_TYPE) {
                return 400;
            }
            if (e.getType() == PApplicationExceptionType.UNKNOWN_METHOD) {
                return 404;
            }
        }
        return 500;
    }
}

