/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProvidenceHttpServlet<RQ extends PMessage<RQ, RQF>, RQF extends PField, RS extends PMessage<RS, RSF>, RSF extends PField>
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceHttpServlet.class);
    private final PMessageDescriptor<RQ, RQF> requestDescriptor;
    private final SerializerProvider serializerProvider;

    public ProvidenceHttpServlet(PMessageDescriptor<RQ, RQF> requestDescriptor) {
        this(requestDescriptor, (SerializerProvider)new DefaultSerializerProvider());
    }

    public ProvidenceHttpServlet(PMessageDescriptor<RQ, RQF> requestDescriptor, SerializerProvider serializerProvider) {
        this.requestDescriptor = requestDescriptor;
        this.serializerProvider = serializerProvider;
    }

    @Nonnull
    protected abstract <T extends Throwable> RS handle(HttpServletRequest var1, RQ var2) throws T;

    @Nonnull
    protected Throwable getResponseException(Throwable e) {
        if (ExecutionException.class.isAssignableFrom(e.getClass())) {
            return this.getResponseException(e.getCause());
        }
        return e;
    }

    protected int statusCodeForException(@Nonnull Throwable exception) {
        if (exception instanceof PApplicationException) {
            PApplicationException e = (PApplicationException)exception;
            if (e.getId() == PApplicationExceptionType.INVALID_PROTOCOL || e.getId() == PApplicationExceptionType.PROTOCOL_ERROR || e.getId() == PApplicationExceptionType.BAD_SEQUENCE_ID || e.getId() == PApplicationExceptionType.INVALID_MESSAGE_TYPE) {
                return 400;
            }
            if (e.getId() == PApplicationExceptionType.UNKNOWN_METHOD) {
                return 404;
            }
        }
        return 500;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RS response;
        PMessage request;
        Serializer requestSerializer = this.serializerProvider.getDefault();
        if (req.getContentType() != null) {
            try {
                MediaType mediaType = MediaType.parse((String)req.getContentType());
                requestSerializer = this.serializerProvider.getSerializer(mediaType.withoutParameters().toString());
            }
            catch (IllegalArgumentException e) {
                resp.sendError(400, "Unknown content-type: " + req.getContentType());
                LOGGER.warn("Unknown content type in request", (Throwable)e);
                return;
            }
        } else {
            LOGGER.debug("Request is missing content type.");
        }
        Serializer responseSerializer = requestSerializer;
        String acceptHeader = req.getHeader("Accept");
        if (acceptHeader != null) {
            String[] entries;
            for (String entry : entries = acceptHeader.split("[,]")) {
                if ((entry = entry.trim()).isEmpty()) continue;
                if ("*/*".equals(entry)) break;
                try {
                    MediaType mediaType = MediaType.parse((String)entry);
                    responseSerializer = this.serializerProvider.getSerializer(mediaType.withoutParameters().toString());
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        try {
            request = requestSerializer.deserialize((InputStream)req.getInputStream(), this.requestDescriptor);
        }
        catch (SerializerException e) {
            LOGGER.info("Failed to deserialize request to {}: {}", new Object[]{req.getServletPath(), e.asString(), e});
            PApplicationException ex = PApplicationException.builder().setId(PApplicationExceptionType.INVALID_PROTOCOL).setMessage(e.getMessage()).build();
            resp.setStatus(this.statusCodeForException((Throwable)ex));
            resp.setContentType(responseSerializer.mediaType());
            responseSerializer.serialize((OutputStream)resp.getOutputStream(), (PMessage)ex);
            return;
        }
        try {
            response = this.handle(req, request);
        }
        catch (Exception e) {
            Throwable rex = this.getResponseException(e);
            if (rex instanceof PMessage) {
                PMessage mex = (PMessage)rex;
                resp.setStatus(this.statusCodeForException(rex));
                resp.setContentType(responseSerializer.mediaType());
                responseSerializer.serialize((OutputStream)resp.getOutputStream(), mex);
            } else {
                resp.sendError(this.statusCodeForException(rex), rex.getMessage());
            }
            return;
        }
        resp.setStatus(200);
        resp.setContentType(responseSerializer.mediaType());
        responseSerializer.serialize((OutputStream)resp.getOutputStream(), response);
    }
}

