/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.mio.IOMessageReader;
import net.morimekta.providence.mio.IOMessageWriter;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.DefaultProcessorHandler;
import net.morimekta.providence.server.ProcessorHandler;
import net.morimekta.providence.server.ProcessorProvider;
import net.morimekta.providence.server.WrappedProcessor;
import net.morimekta.providence.util.ServiceCallInstrumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceServlet.class);
    private final ProcessorProvider processorProvider;
    private final SerializerProvider serializerProvider;
    private final ServiceCallInstrumentation instrumentation;

    public ProvidenceServlet(@Nonnull PProcessor processor, @Nonnull SerializerProvider serializerProvider) {
        this((HttpServletRequest r) -> processor, serializerProvider);
    }

    public ProvidenceServlet(@Nonnull PProcessor processor, @Nonnull SerializerProvider serializerProvider, @Nonnull ServiceCallInstrumentation instrumentation) {
        this((HttpServletRequest r) -> processor, serializerProvider, instrumentation);
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider, @Nonnull SerializerProvider serializerProvider) {
        this(processorProvider, serializerProvider, (time, call, response) -> {});
    }

    public ProvidenceServlet(@Nonnull ProcessorProvider processorProvider, @Nonnull SerializerProvider serializerProvider, @Nonnull ServiceCallInstrumentation instrumentation) {
        this.processorProvider = processorProvider;
        this.serializerProvider = serializerProvider;
        this.instrumentation = instrumentation;
    }

    protected ProcessorHandler getHandler(PProcessor processor) {
        return new DefaultProcessorHandler(processor);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long startTime = System.nanoTime();
        AtomicReference callRef = new AtomicReference();
        AtomicReference responseRef = new AtomicReference();
        WrappedProcessor processor = new WrappedProcessor(this.processorProvider.processorForRequest(req), (c, r) -> {
            callRef.set(c);
            responseRef.set(r.handleCall(c));
            return (PServiceCall)responseRef.get();
        });
        try {
            Serializer requestSerializer = this.serializerProvider.getDefault();
            if (req.getContentType() != null) {
                try {
                    requestSerializer = this.serializerProvider.getSerializer(req.getContentType());
                }
                catch (IllegalArgumentException e) {
                    resp.sendError(400, "Unknown content-type: " + req.getContentType());
                    LOGGER.warn("Unknown content type in request", (Throwable)e);
                    return;
                }
            } else {
                LOGGER.debug("Request is missing content type.");
            }
            Serializer responseSerializer = requestSerializer;
            String acceptHeader = req.getHeader("Accept");
            if (acceptHeader != null) {
                String[] entries;
                for (String entry : entries = acceptHeader.split("[,]")) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    if ("*/*".equals(entry)) break;
                    try {
                        responseSerializer = this.serializerProvider.getSerializer(entry);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            IOMessageReader reader = new IOMessageReader((InputStream)req.getInputStream(), requestSerializer);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOMessageWriter writer = new IOMessageWriter((OutputStream)baos, responseSerializer);
            this.getHandler(processor).process((MessageReader)reader, (MessageWriter)writer);
            resp.setStatus(200);
            if (baos.size() > 0) {
                resp.setContentType(responseSerializer.mediaType());
                resp.setContentLength(baos.size());
                resp.getOutputStream().write(baos.toByteArray());
                resp.getOutputStream().flush();
            }
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)ServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onComplete(duration, (PServiceCall)callRef.get(), (PServiceCall)responseRef.get());
            }
            catch (Throwable th) {
                LOGGER.error("Exception in service instrumentation", th);
            }
        }
        catch (EOFException e) {
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)ServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException((Exception)e, duration, (PServiceCall)callRef.get(), (PServiceCall)responseRef.get());
            }
            catch (Throwable th) {
                LOGGER.error("Exception in service instrumentation", th);
            }
        }
        catch (Exception e) {
            try {
                resp.sendError(500, "Internal server error: " + e.getMessage());
            }
            catch (IOException ioEx) {
                e.addSuppressed(ioEx);
            }
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)ServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onTransportException(e, duration, (PServiceCall)callRef.get(), (PServiceCall)responseRef.get());
            }
            catch (Throwable th) {
                LOGGER.error("Exception in service instrumentation", th);
            }
        }
    }
}

