/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.mio.IOMessageReader;
import net.morimekta.providence.mio.IOMessageWriter;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.providence.server.DefaultProcessorHandler;
import net.morimekta.providence.server.ProcessorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceServlet.class);
    private final ProcessorProvider processorProvider;
    private final SerializerProvider serializerProvider;

    public ProvidenceServlet(PProcessor processor, SerializerProvider serializerProvider) {
        this((HttpServletRequest r) -> processor, serializerProvider);
    }

    public ProvidenceServlet(ProcessorProvider processorProvider, SerializerProvider serializerProvider) {
        this.processorProvider = processorProvider;
        this.serializerProvider = serializerProvider;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PProcessor processor = this.processorProvider.processorForRequest(req);
        try {
            Serializer requestSerializer = this.serializerProvider.getDefault();
            if (req.getContentType() != null) {
                try {
                    MediaType mediaType = MediaType.parse((String)req.getContentType());
                    requestSerializer = this.serializerProvider.getSerializer(mediaType.withoutParameters().toString());
                }
                catch (IllegalArgumentException e) {
                    resp.sendError(400, "Unknown content-type: " + req.getContentType());
                    LOGGER.warn("Unknown content type in request", (Throwable)e);
                    return;
                }
            } else {
                LOGGER.debug("Request is missing content type.");
            }
            Serializer responseSerializer = requestSerializer;
            String acceptHeader = resp.getHeader("Accept");
            if (acceptHeader != null) {
                String[] entries;
                for (String entry : entries = acceptHeader.split("[,]")) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    try {
                        MediaType mediaType = MediaType.parse((String)entry);
                        responseSerializer = this.serializerProvider.getSerializer(mediaType.type() + "/" + mediaType.subtype());
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            IOMessageReader reader = new IOMessageReader((InputStream)req.getInputStream(), requestSerializer);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOMessageWriter writer = new IOMessageWriter((OutputStream)baos, responseSerializer);
            new DefaultProcessorHandler(processor).process((MessageReader)reader, (MessageWriter)writer);
            resp.setStatus(200);
            resp.setContentType(responseSerializer.mediaType());
            resp.setContentLength(baos.size());
            resp.getOutputStream().write(baos.toByteArray());
        }
        catch (Exception e) {
            LOGGER.error("Exception in service call for " + processor.getDescriptor().getQualifiedName(), (Throwable)e);
            resp.sendError(500, "Internal error: " + e.getMessage());
        }
    }
}

