/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.IOException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.server.ProcessorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessorHandler
implements ProcessorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProcessorHandler.class);
    private final PProcessor processor;

    public DefaultProcessorHandler(@Nonnull PProcessor processor) {
        this.processor = processor;
    }

    @Override
    public boolean process(MessageReader reader, MessageWriter writer) throws IOException {
        PServiceCall reply;
        PServiceCall call;
        try {
            call = reader.read(this.processor.getDescriptor());
        }
        catch (SerializerException e) {
            if (e.getMethodName() != null) {
                LOGGER.error("Error when reading service call " + this.processor.getDescriptor().getName() + "." + e.getMethodName() + "()", (Throwable)e);
            } else {
                LOGGER.error("Error when reading service call " + this.processor.getDescriptor().getName(), (Throwable)e);
            }
            try {
                PApplicationException oe = new PApplicationException(e.getMessage(), e.getExceptionType());
                PServiceCall reply2 = new PServiceCall(e.getMethodName(), PServiceCallType.EXCEPTION, e.getSequenceNo(), (PMessage)oe);
                writer.write(reply2);
                return false;
            }
            catch (Exception e2) {
                IOException e3 = new IOException(e.getMessage(), e);
                e3.addSuppressed(e2);
                throw e3;
            }
        }
        try {
            reply = this.processor.handleCall(call);
        }
        catch (Exception e) {
            LOGGER.error("Error when handling service call " + this.processor.getDescriptor().getName() + "." + call.getMethod() + "()", (Throwable)e);
            try {
                PApplicationException oe = new PApplicationException(e.getMessage(), PApplicationExceptionType.INTERNAL_ERROR);
                PServiceCall reply3 = new PServiceCall(call.getMethod(), PServiceCallType.EXCEPTION, call.getSequence(), (PMessage)oe);
                writer.write(reply3);
                return false;
            }
            catch (Exception e2) {
                IOException e3 = new IOException(e.getMessage(), e);
                e3.addSuppressed(e2);
                throw e3;
            }
        }
        if (reply != null) {
            try {
                writer.write(reply);
            }
            catch (SerializerException e) {
                LOGGER.error("Error when replying to service call " + this.processor.getDescriptor().getName() + "." + call.getMethod() + "()", (Throwable)e);
                try {
                    PApplicationException oe = new PApplicationException(e.getMessage(), e.getExceptionType());
                    reply = new PServiceCall(call.getMethod(), PServiceCallType.EXCEPTION, call.getSequence(), (PMessage)oe);
                    writer.write(reply);
                    return false;
                }
                catch (Exception e2) {
                    IOException e3 = new IOException(e.getMessage(), e);
                    e3.addSuppressed(e2);
                    throw e3;
                }
            }
        }
        return true;
    }
}

