/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.client.HttpClientConnectException;
import net.morimekta.providence.client.HttpResponseException;
import net.morimekta.providence.client.okhttp.ProvidenceRequestBody;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.util.io.IOUtils;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClientHandler
implements PServiceCallHandler {
    private final OkHttpClient factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<URL> urlSupplier;
    private final PServiceCallInstrumentation instrumentation;

    public OkHttpClientHandler(@Nonnull Supplier<URL> urlSupplier) {
        this(urlSupplier, new OkHttpClient());
    }

    public OkHttpClientHandler(@Nonnull Supplier<URL> urlSupplier, @Nonnull OkHttpClient factory) {
        this(urlSupplier, factory, (SerializerProvider)new DefaultSerializerProvider());
    }

    public OkHttpClientHandler(@Nonnull Supplier<URL> urlSupplier, @Nonnull OkHttpClient factory, @Nonnull SerializerProvider serializerProvider) {
        this(urlSupplier, factory, serializerProvider, PServiceCallInstrumentation.NOOP);
    }

    public OkHttpClientHandler(@Nonnull Supplier<URL> urlSupplier, @Nonnull OkHttpClient factory, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        this.instrumentation = instrumentation;
    }

    private static String readContent(ResponseBody body) throws IOException {
        if (body == null) {
            return null;
        }
        return IOUtils.readString((InputStream)body.byteStream());
    }

    @Nonnull
    private static String contentType(ResponseBody body) {
        if (body == null) {
            return "*/*";
        }
        MediaType mediaType = body.contentType();
        if (mediaType == null) {
            return "*/*";
        }
        return mediaType.toString();
    }

    public <Request extends PMessage<Request>, Response extends PMessage<Response>> PServiceCall<Response> handleCall(PServiceCall<Request> call, PService service) throws IOException {
        PServiceCall pServiceCall;
        block24: {
            if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
                throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
            }
            long startTime = System.nanoTime();
            PServiceCall reply = null;
            URL url = this.urlSupplier.get();
            ProvidenceRequestBody<Request> content = new ProvidenceRequestBody<Request>(call, this.requestSerializer);
            Request request = new Request.Builder().url(url).post(content).build();
            Response response = this.factory.newCall(request).execute();
            try {
                if (call.getType() == PServiceCallType.CALL) {
                    if (!response.isSuccessful()) {
                        throw new HttpResponseException(url, response.code(), response.message(), OkHttpClientHandler.readContent(response.body()), null);
                    }
                    Serializer responseSerializer = this.requestSerializer;
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        throw new PApplicationException("No response on " + response.code() + " for " + url.toString(), PApplicationExceptionType.PROTOCOL_ERROR);
                    }
                    if (responseBody.contentType() != null) {
                        try {
                            responseSerializer = this.serializerProvider.getSerializer(OkHttpClientHandler.contentType(responseBody));
                        }
                        catch (IllegalArgumentException e) {
                            throw new PApplicationException("Unknown content-type in response: " + responseBody.contentType(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
                        }
                    }
                    reply = responseSerializer.deserialize(responseBody.byteStream(), service);
                    responseSerializer.verifyEndOfContent(responseBody.byteStream());
                    if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                        throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                    }
                    if (reply.getSequence() != call.getSequence()) {
                        throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                    }
                }
                long endTime = System.nanoTime();
                double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                try {
                    this.instrumentation.onComplete(duration, call, reply);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pServiceCall = reply;
                if (response == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable responseBody) {
                                throwable.addSuppressed(responseBody);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConnectException e) {
                        throw new HttpClientConnectException(e, url, InetAddress.getAllByName(url.getHost()));
                    }
                }
                catch (IOException | RuntimeException e) {
                    long endTime = System.nanoTime();
                    double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                    try {
                        this.instrumentation.onTransportException(e, duration, call, reply);
                    }
                    catch (Throwable ie) {
                        e.addSuppressed(ie);
                    }
                    throw e;
                }
            }
            response.close();
        }
        return pServiceCall;
    }
}

