/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client.google;

import com.google.api.client.http.HttpContent;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.serializer.Serializer;

public class ProvidenceHttpContent
implements HttpContent {
    private final Serializer serializer;
    private final PMessageOrBuilder message;
    private final PServiceCall call;
    private int length;

    public ProvidenceHttpContent(@Nonnull PMessageOrBuilder message, @Nonnull Serializer serializer) {
        this.serializer = serializer;
        this.message = message;
        this.call = null;
        this.length = -1;
    }

    public ProvidenceHttpContent(@Nonnull PServiceCall serviceCall, @Nonnull Serializer serializer) {
        this.serializer = serializer;
        this.message = null;
        this.call = serviceCall;
        this.length = -1;
    }

    public long getLength() {
        return this.length;
    }

    public String getType() {
        return this.serializer.mediaType();
    }

    public boolean retrySupported() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.message != null) {
            this.length = this.serializer.serialize(out, this.message);
        } else if (this.call != null) {
            this.length = this.serializer.serialize(out, this.call);
        }
    }
}

