/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client.google;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.client.HttpClientConnectException;
import net.morimekta.providence.client.HttpResponseException;
import net.morimekta.providence.client.google.ProvidenceHttpContent;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import net.morimekta.util.io.IOUtils;

public class GoogleHttpClientHandler
implements PServiceCallHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<GenericUrl> urlSupplier;
    private final PServiceCallInstrumentation instrumentation;

    public GoogleHttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier) {
        this(urlSupplier, new NetHttpTransport().createRequestFactory());
    }

    public GoogleHttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory) {
        this(urlSupplier, factory, (SerializerProvider)new DefaultSerializerProvider());
    }

    public GoogleHttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory, @Nonnull SerializerProvider serializerProvider) {
        this(urlSupplier, factory, serializerProvider, PServiceCallInstrumentation.NOOP);
    }

    public GoogleHttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        this.instrumentation = instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends PMessage<Request>, Response extends PMessage<Response>> PServiceCall<Response> handleCall(PServiceCall<Request> call, PService service) throws IOException {
        PServiceCall pServiceCall;
        if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        long startTime = System.nanoTime();
        PServiceCall reply = null;
        ProvidenceHttpContent content = new ProvidenceHttpContent(call, this.requestSerializer);
        GenericUrl url = this.urlSupplier.get();
        HttpRequest request = this.factory.buildPostRequest(url, (HttpContent)content);
        request.setThrowExceptionOnExecuteError(false).getHeaders().setAccept(this.requestSerializer.mediaType());
        HttpResponse response = request.execute();
        try {
            InputStream in = response.getContent();
            if (response.getStatusCode() != 200) {
                throw new HttpResponseException(url.toURL(), response.getStatusCode(), response.getStatusMessage(), in != null ? Strings.emptyToNull((String)IOUtils.readString((InputStream)in)) : null, null);
            }
            if (in == null) {
                throw new HttpResponseException(url.toURL(), response.getStatusCode(), response.getStatusMessage(), null, null);
            }
            if (call.getType() == PServiceCallType.CALL) {
                Serializer responseSerializer = this.requestSerializer;
                if (response.getContentType() != null) {
                    try {
                        responseSerializer = this.serializerProvider.getSerializer(response.getContentType());
                    }
                    catch (IllegalArgumentException e) {
                        throw new PApplicationException("Unknown content-type in response: " + response.getContentType(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
                    }
                }
                reply = responseSerializer.deserialize(response.getContent(), service);
                responseSerializer.verifyEndOfContent(response.getContent());
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                if (reply.getSequence() != call.getSequence()) {
                    throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                }
            }
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onComplete(duration, call, reply);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pServiceCall = reply;
        }
        catch (Throwable throwable) {
            try {
                try {
                    response.ignore();
                    throw throwable;
                }
                catch (com.google.api.client.http.HttpResponseException e) {
                    throw new HttpResponseException(url.toURL(), e.getStatusCode(), e.getStatusMessage(), e.getContent(), (IOException)((Object)e));
                }
                catch (ConnectException e) {
                    throw new HttpClientConnectException(e, url.toURL(), InetAddress.getAllByName(url.getHost()));
                }
            }
            catch (IOException | RuntimeException e) {
                long endTime = System.nanoTime();
                double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                try {
                    this.instrumentation.onTransportException(e, duration, call, reply);
                }
                catch (Throwable ie) {
                    e.addSuppressed(ie);
                }
                throw e;
            }
        }
        response.ignore();
        return pServiceCall;
    }
}

