/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.morimekta.util.collect.Unmodifiables;

public class HttpClientConnectException
extends ConnectException {
    private static final long serialVersionUID = -6911917568723939145L;

    public HttpClientConnectException(@Nonnull ConnectException cause, @Nonnull URL url, InetAddress ... remoteAddresses) {
        super(HttpClientConnectException.makeMessage(cause, url, remoteAddresses));
        this.initCause(cause);
    }

    private static String makeMessage(@Nonnull Throwable cause, @Nonnull URL url, InetAddress ... remoteAddresses) {
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return "Connect to " + url.getAuthority() + (remoteAddresses.length > 0 ? " " + Arrays.stream(remoteAddresses).map(a -> a.toString().replaceFirst(":(0:)+", "::").replaceFirst("^0::", "::")).collect(Unmodifiables.toList()) : "") + " failed: " + cause.getMessage();
    }
}

