/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.HttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.util.Binary;

public class ProvidenceHttpBufferedContent
implements HttpContent {
    private final String type;
    private final Binary binary;

    public ProvidenceHttpBufferedContent(@Nonnull PMessageOrBuilder message, @Nonnull Serializer serializer) throws IOException {
        this.type = serializer.mediaType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize((OutputStream)baos, message);
        this.binary = Binary.wrap((byte[])baos.toByteArray());
    }

    public ProvidenceHttpBufferedContent(@Nonnull PServiceCall serviceCall, @Nonnull Serializer serializer) throws IOException {
        this.type = serializer.mediaType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize((OutputStream)baos, serviceCall);
        this.binary = Binary.wrap((byte[])baos.toByteArray());
    }

    public long getLength() {
        return this.binary.length();
    }

    public String getType() {
        return this.type;
    }

    public boolean retrySupported() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.binary.write(out);
    }
}

