/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.Serializer;

public class ProvidenceObjectParser
implements ObjectParser {
    private final Serializer serializer;

    public ProvidenceObjectParser(Serializer serializer) {
        this.serializer = serializer;
    }

    @Nonnull
    private PMessageDescriptor getMessageDescriptor(Class<?> aClass) {
        try {
            Field kDescriptor = aClass.getDeclaredField("kDescriptor");
            return (PMessageDescriptor)kDescriptor.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not a providence message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseAndClose(InputStream inputStream, Charset charset, Class<T> aClass) throws IOException {
        try {
            PMessageDescriptor descriptor = this.getMessageDescriptor(aClass);
            PMessage pMessage = this.serializer.deserialize(inputStream, descriptor);
            return (T)pMessage;
        }
        finally {
            this.serializer.verifyEndOfContent(inputStream);
            inputStream.close();
        }
    }

    public Object parseAndClose(InputStream inputStream, Charset charset, Type type) throws IOException {
        if (type instanceof Class && PMessage.class.isAssignableFrom((Class)type)) {
            return this.parseAndClose(inputStream, charset, (Class)type);
        }
        throw new IllegalArgumentException("Class " + type.getTypeName() + " is not a providence message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseAndClose(Reader reader, Class<T> aClass) throws IOException {
        if (this.serializer instanceof JsonSerializer) {
            PMessageDescriptor descriptor = this.getMessageDescriptor(aClass);
            JsonSerializer json = (JsonSerializer)this.serializer;
            try {
                PMessage pMessage = json.deserialize(reader, descriptor);
                return (T)pMessage;
            }
            finally {
                json.verifyEndOfContent(reader);
                reader.close();
            }
        }
        throw new IllegalStateException("Serializer " + this.serializer.toString() + " does not support Reader deserialization");
    }

    public Object parseAndClose(Reader reader, Type type) throws IOException {
        if (type instanceof Class && PMessage.class.isAssignableFrom((Class)type)) {
            return this.parseAndClose(reader, (Class)type);
        }
        throw new IllegalArgumentException("Class " + type.getTypeName() + " is not a providence message");
    }
}

