/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallInstrumentation;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.client.HttpClientConnectException;
import net.morimekta.providence.client.ProvidenceHttpContent;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.DefaultSerializerProvider;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;

public class HttpClientHandler
implements PServiceCallHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<GenericUrl> urlSupplier;
    private final PServiceCallInstrumentation instrumentation;

    public HttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier) {
        this(urlSupplier, new NetHttpTransport().createRequestFactory());
    }

    public HttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory) {
        this(urlSupplier, factory, (SerializerProvider)new DefaultSerializerProvider());
    }

    public HttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory, @Nonnull SerializerProvider serializerProvider) {
        this(urlSupplier, factory, serializerProvider, (d, c, r) -> {});
    }

    public HttpClientHandler(@Nonnull Supplier<GenericUrl> urlSupplier, @Nonnull HttpRequestFactory factory, @Nonnull SerializerProvider serializerProvider, @Nonnull PServiceCallInstrumentation instrumentation) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        this.instrumentation = instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends PMessage<Request>, Response extends PMessage<Response>> PServiceCall<Response> handleCall(PServiceCall<Request> call, PService service) throws IOException {
        PServiceCall pServiceCall;
        if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        long startTime = System.nanoTime();
        PServiceCall reply = null;
        ProvidenceHttpContent content = new ProvidenceHttpContent(call, this.requestSerializer);
        GenericUrl url = this.urlSupplier.get();
        HttpRequest request = this.factory.buildPostRequest(url, (HttpContent)content);
        request.getHeaders().setAccept(this.requestSerializer.mediaType());
        HttpResponse response = request.execute();
        try {
            if (call.getType() == PServiceCallType.CALL) {
                Serializer responseSerializer = this.requestSerializer;
                if (response.getContentType() != null) {
                    try {
                        responseSerializer = this.serializerProvider.getSerializer(response.getContentType());
                    }
                    catch (IllegalArgumentException e) {
                        throw new PApplicationException("Unknown content-type in response: " + response.getContentType(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
                    }
                }
                reply = responseSerializer.deserialize(response.getContent(), service);
                responseSerializer.verifyEndOfContent(response.getContent());
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                if (reply.getSequence() != call.getSequence()) {
                    throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                }
            }
            long endTime = System.nanoTime();
            double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
            try {
                this.instrumentation.onComplete(duration, call, reply);
            }
            catch (Exception exception) {
                // empty catch block
            }
            pServiceCall = reply;
        }
        catch (Throwable throwable) {
            try {
                try {
                    response.ignore();
                    throw throwable;
                }
                catch (ConnectException e) {
                    throw new HttpClientConnectException(e, url, InetAddress.getAllByName(url.getHost()));
                }
            }
            catch (IOException | RuntimeException e) {
                long endTime = System.nanoTime();
                double duration = (double)(endTime - startTime) / (double)PServiceCallInstrumentation.NS_IN_MILLIS;
                try {
                    this.instrumentation.onTransportException(e, duration, call, reply);
                }
                catch (Throwable ie) {
                    e.addSuppressed(ie);
                }
                throw e;
            }
        }
        response.ignore();
        return pServiceCall;
    }
}

