/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.Serializer;

public class ProvidenceObjectParser
implements ObjectParser {
    private final Serializer provider;

    public ProvidenceObjectParser(Serializer provider) {
        this.provider = provider;
    }

    @Nonnull
    private PMessageDescriptor getMessageDescriptor(Class<?> aClass) {
        try {
            Field kDescriptor = aClass.getDeclaredField("kDescriptor");
            return (PMessageDescriptor)kDescriptor.get(null);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Class " + aClass.getName() + " is not a providence message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseAndClose(InputStream inputStream, Charset charset, Class<T> aClass) throws IOException {
        try {
            PMessageDescriptor descriptor = this.getMessageDescriptor(aClass);
            PMessage pMessage = this.provider.deserialize(inputStream, descriptor);
            return (T)pMessage;
        }
        finally {
            inputStream.close();
        }
    }

    public Object parseAndClose(InputStream inputStream, Charset charset, Type type) throws IOException {
        if (type instanceof Class) {
            return this.parseAndClose(inputStream, charset, (Class)type);
        }
        try {
            Class<?> aClass = ProvidenceObjectParser.class.getClassLoader().loadClass(type.getTypeName());
            return this.parseAndClose(inputStream, charset, aClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class " + type.getTypeName() + " is not a providence message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseAndClose(Reader reader, Class<T> aClass) throws IOException {
        if (this.provider instanceof JsonSerializer) {
            PMessageDescriptor descriptor = this.getMessageDescriptor(aClass);
            JsonSerializer json = (JsonSerializer)this.provider;
            try {
                PMessage pMessage = json.deserialize(reader, descriptor);
                return (T)pMessage;
            }
            finally {
                reader.close();
            }
        }
        throw new IllegalStateException("Serializer " + this.provider.toString() + " does not support Reader deserialization");
    }

    public Object parseAndClose(Reader reader, Type type) throws IOException {
        if (type instanceof Class) {
            return this.parseAndClose(reader, (Class)type);
        }
        try {
            Class<?> aClass = ProvidenceObjectParser.class.getClassLoader().loadClass(type.getTypeName());
            return this.parseAndClose(reader, aClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

