/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.HttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.util.Binary;

public class ProvidenceHttpContent
implements HttpContent {
    private final String type;
    private final Binary binary;

    public ProvidenceHttpContent(@Nonnull PMessage message, @Nonnull Serializer serializer) throws IOException {
        this.type = serializer.mediaType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize((OutputStream)baos, message);
        this.binary = Binary.wrap((byte[])baos.toByteArray());
    }

    public long getLength() {
        return this.binary.length();
    }

    public String getType() {
        return this.type;
    }

    public boolean retrySupported() {
        return true;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.binary.write(out);
    }
}

