/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.common.net.MediaType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.function.Supplier;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpHostConnectException;

public class HttpClientHandler
implements PServiceCallHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<GenericUrl> urlSupplier;

    public HttpClientHandler(Supplier<GenericUrl> urlSupplier, HttpRequestFactory factory, SerializerProvider serializerProvider) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends PMessage<Request, RequestField>, Response extends PMessage<Response, ResponseField>, RequestField extends PField, ResponseField extends PField> PServiceCall<Response, ResponseField> handleCall(PServiceCall<Request, RequestField> call, PService service) throws IOException {
        PServiceCall pServiceCall;
        if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.requestSerializer.serialize((OutputStream)baos, call);
        ByteArrayContent content = new ByteArrayContent(this.requestSerializer.mediaType(), baos.toByteArray());
        GenericUrl url = this.urlSupplier.get();
        HttpRequest request = this.factory.buildPostRequest(url, (HttpContent)content);
        request.getHeaders().setAccept(this.requestSerializer.mediaType());
        HttpResponse response = request.execute();
        try {
            Serializer responseSerializer = this.requestSerializer;
            if (response.getContentType() != null) {
                try {
                    MediaType mediaType = MediaType.parse((String)response.getContentType());
                    responseSerializer = this.serializerProvider.getSerializer(mediaType.withoutParameters().toString());
                }
                catch (IllegalArgumentException e) {
                    throw new PApplicationException("Unknown content-type in response: " + response.getContentType(), PApplicationExceptionType.INVALID_PROTOCOL).initCause((Throwable)e);
                }
            }
            PServiceCall reply = null;
            if (call.getType() == PServiceCallType.CALL) {
                reply = responseSerializer.deserialize(response.getContent(), service);
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                if (reply.getSequence() != call.getSequence()) {
                    throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                }
            }
            pServiceCall = reply;
        }
        catch (Throwable throwable) {
            try {
                response.ignore();
                throw throwable;
            }
            catch (HttpHostConnectException e) {
                throw e;
            }
            catch (ConnectException e) {
                throw new HttpHostConnectException((IOException)e, new HttpHost(url.getHost(), url.getPort(), url.getScheme()), new InetAddress[0]);
            }
        }
        response.ignore();
        return pServiceCall;
    }
}

