/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.function.Supplier;
import net.morimekta.providence.PApplicationException;
import net.morimekta.providence.PApplicationExceptionType;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallHandler;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerProvider;
import org.apache.http.HttpHost;
import org.apache.http.conn.HttpHostConnectException;

public class HttpClientHandler
implements PServiceCallHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<GenericUrl> urlSupplier;

    public HttpClientHandler(Supplier<GenericUrl> urlSupplier, HttpRequestFactory factory, SerializerProvider serializerProvider) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        if (this.requestSerializer == null) {
            throw new IllegalStateException("Serializer provider has no default serializer");
        }
    }

    public <Request extends PMessage<Request, RequestField>, Response extends PMessage<Response, ResponseField>, RequestField extends PField, ResponseField extends PField> PServiceCall<Response, ResponseField> handleCall(PServiceCall<Request, RequestField> call, PService service) throws IOException {
        if (call.getType() == PServiceCallType.EXCEPTION || call.getType() == PServiceCallType.REPLY) {
            throw new PApplicationException("Request with invalid call type: " + call.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.requestSerializer.serialize((OutputStream)baos, call);
        ByteArrayContent content = new ByteArrayContent(this.requestSerializer.mimeType(), baos.toByteArray());
        GenericUrl url = this.urlSupplier.get();
        try {
            HttpRequest request = this.factory.buildPostRequest(url, (HttpContent)content);
            request.getHeaders().setContentType(this.requestSerializer.mimeType());
            request.getHeaders().setAccept(this.requestSerializer.mimeType());
            HttpResponse response = request.execute();
            Serializer responseSerializer = this.requestSerializer;
            if (response.getContentType() != null && (responseSerializer = this.serializerProvider.getSerializer(response.getContentType())) == null) {
                throw new PApplicationException("Unknown content-type in response: " + response.getContentType(), PApplicationExceptionType.INVALID_PROTOCOL);
            }
            PServiceCall reply = null;
            if (call.getType() == PServiceCallType.CALL) {
                reply = responseSerializer.deserialize(response.getContent(), service);
                if (reply.getType() == PServiceCallType.CALL || reply.getType() == PServiceCallType.ONEWAY) {
                    throw new PApplicationException("Reply with invalid call type: " + reply.getType(), PApplicationExceptionType.INVALID_MESSAGE_TYPE);
                }
                if (reply.getSequence() != call.getSequence()) {
                    throw new PApplicationException("Reply sequence out of order: call = " + call.getSequence() + ", reply = " + reply.getSequence(), PApplicationExceptionType.BAD_SEQUENCE_ID);
                }
            }
            return reply;
        }
        catch (HttpHostConnectException e) {
            throw e;
        }
        catch (ConnectException e) {
            throw new HttpHostConnectException(new HttpHost(url.getHost(), url.getPort(), url.getScheme()), e);
        }
    }
}

