/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public class HttpClientHandler
implements PClientHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final Supplier<GenericUrl> urlSupplier;

    public HttpClientHandler(Supplier<GenericUrl> urlSupplier, HttpRequestFactory factory, SerializerProvider serializerProvider) {
        this.urlSupplier = urlSupplier;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        if (this.requestSerializer == null) {
            throw new IllegalStateException("Serializer provider has no default serializer");
        }
    }

    public <Request extends PMessage<Request, RequestField>, Response extends PMessage<Response, ResponseField>, RequestField extends PField, ResponseField extends PField> PServiceCall<Response, ResponseField> handleCall(PServiceCall<Request, RequestField> pServiceCall, PService service) throws IOException, SerializerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.requestSerializer.serialize((OutputStream)baos, pServiceCall);
        ByteArrayContent content = new ByteArrayContent(this.requestSerializer.mimeType(), baos.toByteArray());
        HttpRequest request = this.factory.buildPostRequest(this.urlSupplier.get(), (HttpContent)content);
        HttpResponse response = request.execute();
        Serializer responseSerializer = this.requestSerializer;
        if (response.getContentType() != null && (responseSerializer = this.serializerProvider.getSerializer(response.getContentType())) == null) {
            throw new IOException("Unknown mime type in response: " + response.getContentType());
        }
        return responseSerializer.deserialize(response.getContent(), service);
    }
}

