/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PProcessor;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.mio.IOMessageReader;
import net.morimekta.providence.mio.IOMessageWriter;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.serializer.ApplicationException;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public class ProvidenceServlet
extends HttpServlet {
    private final PProcessor processor;
    private final SerializerProvider serializerProvider;

    public ProvidenceServlet(PProcessor processor, SerializerProvider serializerProvider) {
        this.processor = processor;
        this.serializerProvider = serializerProvider;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Serializer requestSerializer = this.serializerProvider.getDefault();
        if (req.getContentType() != null && (requestSerializer = this.serializerProvider.getSerializer(req.getContentType())) == null) {
            resp.sendError(400, "Unknown content-type: " + req.getContentType());
            return;
        }
        Serializer responseSerializer = requestSerializer;
        String accept = resp.getHeader("Accept");
        if (accept != null) {
            responseSerializer = this.serializerProvider.getSerializer(accept);
            if (responseSerializer == null) {
                resp.sendError(400, "Unknown accept content-type: " + accept);
                return;
            }
        } else {
            accept = responseSerializer.mimeType();
        }
        try {
            IOMessageReader reader = new IOMessageReader((InputStream)req.getInputStream(), requestSerializer);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOMessageWriter writer = new IOMessageWriter((OutputStream)baos, responseSerializer);
            try {
                this.processor.process((MessageReader)reader, (MessageWriter)writer);
            }
            catch (IOException ie) {
                writer.write(new PServiceCall("", PServiceCallType.EXCEPTION, 0, (PMessage)new ApplicationException(ie.getMessage(), ApplicationExceptionType.INTERNAL_ERROR)));
                return;
            }
            resp.setStatus(200);
            resp.setContentType(accept);
            resp.getOutputStream().write(baos.toByteArray());
        }
        catch (IOException | SerializerException e) {
            resp.sendError(500, "Internal error: " + e.getMessage());
        }
    }
}

