/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public class HttpClientHandler
implements PClientHandler {
    private final HttpRequestFactory factory;
    private final SerializerProvider serializerProvider;
    private final Serializer requestSerializer;
    private final GenericUrl endpoint;

    public HttpClientHandler(GenericUrl endpoint, HttpRequestFactory factory, SerializerProvider serializerProvider) {
        this.endpoint = endpoint;
        this.factory = factory;
        this.serializerProvider = serializerProvider;
        this.requestSerializer = serializerProvider.getDefault();
        if (this.requestSerializer == null) {
            throw new IllegalStateException("Serializer provider has no default serializer");
        }
    }

    public <RQ extends PMessage<RQ>, RS extends PMessage<RS>> PServiceCall<RS> handleCall(PServiceCall<RQ> pServiceCall, PService service) throws IOException, SerializerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.requestSerializer.serialize((OutputStream)baos, pServiceCall);
        ByteArrayContent content = new ByteArrayContent(this.requestSerializer.mimeType(), baos.toByteArray());
        HttpRequest request = this.factory.buildPostRequest(this.endpoint, (HttpContent)content);
        HttpResponse response = request.execute();
        Serializer responseSerializer = this.requestSerializer;
        if (response.getContentType() != null && (responseSerializer = this.serializerProvider.getSerializer(response.getContentType())) == null) {
            throw new IOException("Unknown mime type in response: " + response.getContentType());
        }
        return responseSerializer.deserialize(response.getContent(), service);
    }
}

