/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.json;

import java.util.Objects;
import net.morimekta.util.Slice;

public class JsonToken
extends Slice {
    public static final byte[] kNull = new byte[]{110, 117, 108, 108};
    public static final byte[] kTrue = new byte[]{116, 114, 117, 101};
    public static final byte[] kFalse = new byte[]{102, 97, 108, 115, 101};
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kListSep = ',';
    public static final char kMapStart = '{';
    public static final char kMapEnd = '}';
    public static final char kKeyValSep = ':';
    protected static final char kDoubleQuote = '\"';
    protected static final char kEscape = '\\';
    protected static final char kSpace = ' ';
    protected static final char kTab = '\t';
    protected static final char kNewLine = '\n';
    protected static final char kCarriageReturn = '\r';
    public final Type type;
    public final int lineNo;
    public final int linePos;

    public JsonToken(Type type, byte[] lineBuffer, int offset, int len, int lineNo, int linePos) {
        super(lineBuffer, offset, len);
        this.type = type;
        this.lineNo = lineNo;
        this.linePos = linePos;
    }

    public boolean isNull() {
        return this.type == Type.TOKEN && this.strEquals(kNull);
    }

    public boolean isSymbol() {
        return this.length() == 1 && "{}[],:".indexOf(this.charAt(0)) >= 0;
    }

    public final boolean isSymbol(char c) {
        return this.length() == 1 && this.charAt(0) == c;
    }

    public boolean isLiteral() {
        return this.type == Type.LITERAL && this.length() >= 2;
    }

    public boolean isBoolean() {
        return this.type == Type.TOKEN && this.strEquals(kTrue) || this.strEquals(kFalse);
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isInteger() {
        return this.type == Type.NUMBER && !this.containsAny(46, 101, 69);
    }

    public boolean isDouble() {
        return this.type == Type.NUMBER && this.containsAny(46, 101, 69);
    }

    public boolean booleanValue() {
        return this.strEquals(kTrue);
    }

    public byte byteValue() {
        return (byte)this.parseInteger();
    }

    public short shortValue() {
        return (short)this.parseInteger();
    }

    public int intValue() {
        return (int)this.parseInteger();
    }

    public long longValue() {
        return this.parseInteger();
    }

    public double doubleValue() {
        return this.parseDouble();
    }

    public String decodeJsonLiteral() {
        String tmp = this.substring(1, -1).asString();
        int l = tmp.length();
        StringBuilder out = new StringBuilder(l);
        boolean esc = false;
        for (int i = 0; i < l; ++i) {
            if (esc) {
                esc = false;
                char ch = tmp.charAt(i);
                switch (ch) {
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        out.append(ch);
                        break;
                    }
                    case 'u': {
                        if (l < i + 5) {
                            out.append('?');
                        } else {
                            String n = tmp.substring(i + 1, i + 5);
                            try {
                                int cp = Integer.parseInt(n, 16);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                out.append('?');
                            }
                        }
                        i += 4;
                        break;
                    }
                    default: {
                        out.append('?');
                        break;
                    }
                }
                continue;
            }
            if (tmp.charAt(i) == '\\') {
                esc = true;
                continue;
            }
            out.append(tmp.charAt(i));
        }
        return out.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{JsonToken.class, super.hashCode(), this.type, this.lineNo, this.linePos});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof JsonToken)) {
            return false;
        }
        JsonToken other = (JsonToken)o;
        return this.fb == other.fb && this.off == other.off && this.len == other.len && this.type == other.type && this.lineNo == other.lineNo && this.linePos == other.linePos;
    }

    @Override
    public String toString() {
        return String.format("%s('%s',%d:%d-%d)", this.type.toString(), this.asString(), this.lineNo, this.linePos, this.linePos + this.length());
    }

    public static enum Type {
        SYMBOL,
        NUMBER,
        LITERAL,
        TOKEN;

    }
}

