/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.json;

import java.io.IOException;
import net.morimekta.util.Strings;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;

public class JsonException
extends Exception {
    private final String line;
    private final int lineNo;
    private final int linePos;
    private final int len;

    public JsonException(String message) {
        this(message, null, 0, 0, 0);
    }

    public JsonException(String message, String line, int lineNo, int linePos, int len) {
        super(message);
        this.line = line;
        this.lineNo = lineNo;
        this.linePos = linePos;
        this.len = len;
    }

    public JsonException(String message, JsonTokenizer tokenizer, JsonToken token) throws IOException {
        super(message);
        this.line = tokenizer.getLine(token.lineNo);
        this.lineNo = token.lineNo;
        this.linePos = token.linePos;
        this.len = token.length();
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public int getLen() {
        return this.len;
    }

    public String describe() {
        if (this.getLine() != null) {
            return String.format("JSON Error on line %d: %s\n# %s\n#%s%s", this.getLineNo(), this.getLocalizedMessage(), this.getLine(), Strings.times("-", this.getLinePos()), Strings.times("^", this.getLen()));
        }
        return String.format("JSON Error: %s", this.getLocalizedMessage());
    }

    @Override
    public String toString() {
        return String.format("JsonException(%s)", this.describe());
    }
}

