/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Stack;

public class IndentedPrintWriter
extends PrintWriter {
    public static final String NEWLINE = "\n";
    public static final String INDENT = "    ";
    private final Stack<String> indents;
    private final String indent;
    private final String newline;
    private String current;

    public IndentedPrintWriter(OutputStream out) {
        this(out, INDENT, NEWLINE);
    }

    public IndentedPrintWriter(OutputStream out, String indent, String newline) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8), indent, newline);
    }

    public IndentedPrintWriter(Writer out) {
        this(out, INDENT, NEWLINE);
    }

    public IndentedPrintWriter(Writer out, String indent, String newline) {
        super(out);
        this.indent = indent;
        this.newline = newline;
        this.indents = new Stack();
        this.current = "";
    }

    public IndentedPrintWriter begin() {
        return this.begin(this.indent);
    }

    public IndentedPrintWriter begin(String indent) {
        this.indents.push(this.current);
        this.current = this.current + indent;
        return this;
    }

    public IndentedPrintWriter end() {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("No indent to end");
        }
        this.current = this.indents.pop();
        return this;
    }

    public IndentedPrintWriter newline() {
        return this.append(this.newline);
    }

    public IndentedPrintWriter appendln() {
        this.newline();
        super.append(this.current);
        return this;
    }

    public IndentedPrintWriter appendln(char c) {
        this.appendln();
        super.append(c);
        return this;
    }

    public IndentedPrintWriter appendln(CharSequence str) {
        this.appendln();
        super.append(str);
        return this;
    }

    public IndentedPrintWriter formatln(String format, Object ... args) {
        this.appendln();
        super.format(format, args);
        return this;
    }

    @Override
    public IndentedPrintWriter printf(String format, Object ... args) {
        super.format(format, args);
        return this;
    }

    @Override
    public IndentedPrintWriter printf(Locale l, String format, Object ... args) {
        super.format(l, format, args);
        return this;
    }

    @Override
    public IndentedPrintWriter format(String format, Object ... args) {
        super.format(format, args);
        return this;
    }

    @Override
    public IndentedPrintWriter format(Locale l, String format, Object ... args) {
        super.format(l, format, args);
        return this;
    }

    @Override
    public IndentedPrintWriter append(CharSequence str) {
        super.append(str);
        return this;
    }

    @Override
    public IndentedPrintWriter append(CharSequence str, int start, int end) {
        super.append(str, start, end);
        return this;
    }

    @Override
    public IndentedPrintWriter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public void println() {
        this.newline();
    }

    @Override
    public void println(boolean x) {
        this.appendln().print(x);
    }

    @Override
    public void println(char x) {
        this.appendln().print(x);
    }

    @Override
    public void println(int x) {
        this.appendln().print(x);
    }

    @Override
    public void println(long x) {
        this.appendln().print(x);
    }

    @Override
    public void println(float x) {
        this.appendln().print(x);
    }

    @Override
    public void println(double x) {
        this.appendln().print(x);
    }

    @Override
    public void println(char[] x) {
        this.appendln().print(x);
    }

    @Override
    public void println(String x) {
        this.appendln(x);
    }

    @Override
    public void println(Object x) {
        this.appendln(String.valueOf(x));
    }
}

