/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.util.io.BinaryWriter;

public class BigEndianBinaryWriter
extends BinaryWriter {
    public BigEndianBinaryWriter(OutputStream out) {
        super(out);
    }

    @Override
    public int writeShort(short integer) throws IOException {
        this.out.write(integer >>> 8);
        this.out.write(integer);
        return 2;
    }

    @Override
    public int writeInt(int integer) throws IOException {
        this.out.write(integer >>> 24);
        this.out.write(integer >>> 16);
        this.out.write(integer >>> 8);
        this.out.write(integer);
        return 4;
    }

    @Override
    public int writeLong(long integer) throws IOException {
        this.out.write((int)(integer >>> 56));
        this.out.write((int)(integer >>> 48));
        this.out.write((int)(integer >>> 40));
        this.out.write((int)(integer >>> 32));
        this.out.write((int)(integer >>> 24));
        this.out.write((int)(integer >>> 16));
        this.out.write((int)(integer >>> 8));
        this.out.write((int)integer);
        return 8;
    }

    @Override
    public int writeUInt16(int number) throws IOException {
        this.out.write(number >>> 8);
        this.out.write(number);
        return 2;
    }

    @Override
    public int writeUInt24(int number) throws IOException {
        this.out.write(number >>> 16);
        this.out.write(number >>> 8);
        this.out.write(number);
        return 3;
    }

    @Override
    public int writeUInt32(int number) throws IOException {
        this.out.write(number >>> 24);
        this.out.write(number >>> 16);
        this.out.write(number >>> 8);
        this.out.write(number);
        return 4;
    }
}

