/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CStructDescriptor;

public class CStruct
extends CMessage<CStruct, CField> {
    CStructDescriptor descriptor;

    private CStruct(Builder builder) {
        super(builder.getValueMap());
        this.descriptor = builder.descriptor;
    }

    @Override
    public PMessageBuilder<CStruct, CField> mutate() {
        return new Builder(this.descriptor);
    }

    @Override
    public CStructDescriptor descriptor() {
        return this.descriptor;
    }

    public static class Builder
    extends PMessageBuilder<CStruct, CField> {
        private final CStructDescriptor descriptor;
        private final Map<Integer, Object> values;

        public Builder(CStructDescriptor descriptor) {
            this.descriptor = descriptor;
            this.values = new TreeMap<Integer, Object>();
        }

        public Builder merge(CStruct from) {
            block5: for (CField field : this.descriptor.getFields()) {
                int key = field.getKey();
                if (!from.has(key)) continue;
                switch (field.getType()) {
                    case MESSAGE: {
                        this.mutator(key).merge((PMessage)from.get(key));
                        continue block5;
                    }
                    case SET: {
                        if (this.values.containsKey(key)) {
                            ((PSet.Builder)this.values.get(key)).addAll((Collection)from.get(key));
                            continue block5;
                        }
                        this.set(key, from.get(key));
                        continue block5;
                    }
                    case MAP: {
                        if (this.values.containsKey(key)) {
                            ((PMap.Builder)this.values.get(key)).putAll((Map)from.get(key));
                            continue block5;
                        }
                        this.set(key, from.get(key));
                        continue block5;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        @Override
        public PMessageBuilder mutator(int key) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such field ID " + key);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
            }
            PMessageBuilder current = this.values.get(key);
            if (current == null) {
                current = ((PStructDescriptor)field.getDescriptor()).builder();
                this.values.put(key, current);
            } else if (current instanceof PMessage) {
                current = ((PMessage)((Object)current)).mutate();
                this.values.put(key, current);
            } else if (!(current instanceof PMessageBuilder)) {
                throw new IllegalArgumentException("Invalid value in map on message type: " + current.getClass().getSimpleName());
            }
            return current;
        }

        @Override
        public PStructDescriptor<CStruct, CField> descriptor() {
            return this.descriptor;
        }

        @Override
        public CStruct build() {
            return new CStruct(this);
        }

        @Override
        public boolean isValid() {
            for (CField field : this.descriptor.getFields()) {
                if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getKey())) continue;
                return false;
            }
            return true;
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value == null) {
                this.values.remove(key);
            } else {
                switch (field.getType()) {
                    case LIST: {
                        PBuilder builder = ((PList)field.getDescriptor()).builder();
                        builder.addAll((Collection)value);
                        this.values.put(key, builder);
                        break;
                    }
                    case SET: {
                        PBuilder builder = ((PSet)field.getDescriptor()).builder();
                        builder.addAll((Collection)value);
                        this.values.put(key, builder);
                        break;
                    }
                    case MAP: {
                        PBuilder builder = ((PMap)field.getDescriptor()).builder();
                        builder.putAll((Map)value);
                        this.values.put(key, builder);
                        break;
                    }
                    default: {
                        this.values.put(key, value);
                    }
                }
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    PBuilder list = (PList.Builder)this.values.get(field.getKey());
                    if (list == null) {
                        list = ((PList)field.getDescriptor()).builder();
                        this.values.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    PBuilder set = (PSet.Builder)this.values.get(field.getKey());
                    if (set == null) {
                        set = ((PSet)field.getDescriptor()).builder();
                        this.values.put(field.getKey(), set);
                    }
                    set.add(value);
                } else {
                    throw new IllegalArgumentException("Key " + key + " is not a collection: " + (Object)((Object)field.getType()));
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.values.remove(key);
            return this;
        }

        private Map<Integer, Object> getValueMap() {
            ImmutableMap.Builder<Integer, Object> out = ImmutableMap.builder();
            block6: for (CField field : this.descriptor.getFields()) {
                int key = field.getKey();
                if (!this.values.containsKey(key)) continue;
                switch (field.getType()) {
                    case SET: {
                        out.put(key, ((PSet.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case LIST: {
                        out.put(key, ((PList.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case MAP: {
                        out.put(key, ((PMap.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case MESSAGE: {
                        Object current = this.values.get(key);
                        if (current instanceof PMessageBuilder) {
                            out.put(key, ((PMessageBuilder)current).build());
                            continue block6;
                        }
                        out.put(key, current);
                        continue block6;
                    }
                    default: {
                        out.put(key, this.values.get(key));
                    }
                }
            }
            return out.build();
        }
    }
}

