/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.parser.DocumentParser;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.util.DocumentConverter;
import net.morimekta.providence.reflect.util.TypeRegistry;

public class TypeLoader {
    private final TypeRegistry mRegistry;
    private final DocumentConverter mConverter;
    private final DocumentParser mParser;
    private final Map<String, ThriftDocument> mLoadedDocuments;
    private final Collection<File> mIncludes;

    public TypeLoader(Collection<File> includes, DocumentParser parser) {
        this(includes, parser, new TypeRegistry());
    }

    private TypeLoader(Collection<File> includes, DocumentParser parser, TypeRegistry registry) {
        this(includes, parser, registry, new DocumentConverter(registry));
    }

    protected TypeLoader(Collection<File> includes, DocumentParser parser, TypeRegistry registry, DocumentConverter converter) {
        this.mIncludes = includes;
        this.mParser = parser;
        this.mRegistry = registry;
        this.mConverter = converter;
        this.mLoadedDocuments = new LinkedHashMap<String, ThriftDocument>();
    }

    public Collection<ThriftDocument> loadedDocuments() {
        return this.mLoadedDocuments.values();
    }

    public CDocument load(File file) throws IOException, ParseException {
        if (!(file = file.getCanonicalFile()).exists()) {
            throw new IllegalArgumentException("No such file " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Unable to load thrift definition from directory: " + file.getCanonicalPath());
        }
        CDocument cdoc = this.mRegistry.getDocument(file.getCanonicalPath());
        if (cdoc != null) {
            return cdoc;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ThriftDocument doc = this.mParser.parse(in, file.getName());
        LinkedList<File> queue = new LinkedList<File>();
        for (String string : doc.getIncludes()) {
            File location = new File(file.getParent(), string).getCanonicalFile();
            if (!location.exists()) {
                for (File inc : this.mIncludes) {
                    File i = new File(inc, string);
                    if (!i.exists()) continue;
                    location = i.getCanonicalFile();
                    break;
                }
            }
            if (!location.exists() || queue.contains(location)) continue;
            queue.add(location);
        }
        Collections.reverse(queue);
        this.mLoadedDocuments.put(file.getCanonicalPath(), doc);
        for (File file2 : queue) {
            if (this.mLoadedDocuments.containsKey(file2.getCanonicalPath())) continue;
            this.load(file2);
        }
        cdoc = this.mConverter.convert(doc);
        this.mRegistry.putDocument(file.getCanonicalPath(), cdoc);
        return cdoc;
    }

    public TypeRegistry getRegistry() {
        return this.mRegistry;
    }
}

