/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.converter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.morimekta.console.args.Argument;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentOptions;
import net.morimekta.console.args.ArgumentParser;
import net.morimekta.console.args.Flag;
import net.morimekta.console.args.Option;
import net.morimekta.console.util.Parser;
import net.morimekta.console.util.TerminalSize;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.converter.options.ConvertStream;
import net.morimekta.providence.converter.options.ConvertStreamParser;
import net.morimekta.providence.converter.options.Format;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.TypeLoader;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ThriftDocumentParser;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.FastBinarySerializer;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.streams.MessageCollectors;
import net.morimekta.providence.streams.MessageStreams;
import net.morimekta.providence.thrift.TBinaryProtocolSerializer;
import net.morimekta.providence.thrift.TCompactProtocolSerializer;
import net.morimekta.providence.thrift.TJsonProtocolSerializer;
import net.morimekta.providence.thrift.TTupleProtocolSerializer;

public class ConvertOptions {
    protected List<File> includes = new LinkedList<File>();
    protected ConvertStream in = new ConvertStream(Format.json, null);
    protected ConvertStream out = new ConvertStream(Format.pretty, null);
    protected boolean strict = false;
    protected String type;
    protected boolean mHelp;

    public ArgumentParser getArgumentParser(String prog, String version, String description) {
        ArgumentOptions opts = ArgumentOptions.defaults().withUsageWidth(Math.min(120, TerminalSize.get().cols));
        ArgumentParser parser = new ArgumentParser(prog, version, description, opts);
        parser.add(new Option("--include", "I", "Include from directories.", "dir", Parser.dir(this::addInclude), "${PWD}", true, false, false));
        parser.add(new Option("--in", "i", "Input specification", "spec", new ConvertStreamParser().andApply(this::setIn)));
        parser.add(new Option("--out", "o", "Output specification", "spec", new ConvertStreamParser().andApply(this::setOut)));
        parser.add(new Flag("--strict", "S", "Read incoming messages strictly.", this::setStrict));
        parser.add(new Argument("type", "Qualified identifier name from definitions to use for parsing source file.", this::setType));
        parser.add(new Flag("--help", "h?", "This help listing.", this::setHelp));
        return parser;
    }

    public void addInclude(File include) {
        this.includes.add(include);
    }

    public void setIn(ConvertStream in) {
        this.in = in;
    }

    public void setOut(ConvertStream out) {
        this.out = out;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHelp(boolean mHelp) {
        this.mHelp = mHelp;
    }

    protected Serializer getSerializer(Format format) {
        switch (format) {
            case binary: {
                return new BinarySerializer(this.strict);
            }
            case json: {
                return new JsonSerializer(this.strict, JsonSerializer.IdType.ID);
            }
            case named_json: {
                return new JsonSerializer(this.strict, JsonSerializer.IdType.NAME);
            }
            case pretty_json: {
                return new JsonSerializer(this.strict, JsonSerializer.IdType.NAME, JsonSerializer.IdType.NAME, true);
            }
            case fast_binary: {
                return new FastBinarySerializer(this.strict);
            }
            case binary_protocol: {
                return new TBinaryProtocolSerializer(this.strict);
            }
            case json_protocol: {
                return new TJsonProtocolSerializer(this.strict);
            }
            case compact_protocol: {
                return new TCompactProtocolSerializer(this.strict);
            }
            case tuple_protocol: {
                return new TTupleProtocolSerializer(this.strict);
            }
            case pretty: {
                return new PrettySerializer("  ", " ", "\n", "", false, true);
            }
        }
        throw new ArgumentException("Unknown format %s", format.name());
    }

    public boolean isHelp() {
        return this.mHelp;
    }

    public void collectIncludes(File dir, Map<String, File> includes) {
        if (!dir.exists()) {
            throw new ArgumentException("No such include directory: " + dir.getPath(), new Object[0]);
        }
        if (!dir.isDirectory()) {
            throw new ArgumentException("Not a directory: " + dir.getPath(), new Object[0]);
        }
        for (File file : dir.listFiles()) {
            if (file.isHidden() || !file.isFile() || !file.canRead() || !ReflectionUtils.isThriftFile(file.getName())) continue;
            includes.put(ReflectionUtils.packageFromName(file.getName()), file);
        }
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> PStructDescriptor<Message, Field> getDefinition() throws ParseException {
        if (this.type.isEmpty()) {
            throw new ArgumentException("Input type.", new Object[0]);
        }
        HashMap<String, File> includeMap = new HashMap<String, File>();
        if (this.includes.isEmpty()) {
            this.includes.add(new File("."));
        }
        for (File file : this.includes) {
            this.collectIncludes(file, includeMap);
        }
        TreeSet<File> rootSet = new TreeSet<File>();
        for (File file : includeMap.values()) {
            rootSet.add(file.getParentFile());
        }
        String string2 = this.type.substring(0, this.type.lastIndexOf("."));
        string2 = string2.replaceAll("[-.]", "_");
        TypeLoader loader = new TypeLoader(rootSet, new ThriftDocumentParser());
        try {
            loader.load((File)includeMap.get(string2));
        }
        catch (IOException e) {
            throw new ArgumentException(e.getLocalizedMessage(), new Object[0]);
        }
        PStructDescriptor descriptor = (PStructDescriptor)loader.getRegistry().getDescriptor(this.type, null);
        if (descriptor == null) {
            throw new ArgumentException("No available type for name %s", this.type);
        }
        return descriptor;
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> Collector<Message, OutputStream, Integer> getOutput() throws IOException {
        Format fmt = Format.pretty;
        File file = null;
        if (this.out != null) {
            fmt = this.out.format != null ? this.out.format : fmt;
            file = this.out.file;
        }
        Serializer serializer = this.getSerializer(fmt);
        if (file != null) {
            if (file.exists() && !file.isFile()) {
                throw new ArgumentException("%s exists and is not a file.", file.getAbsolutePath());
            }
            return MessageCollectors.toFile(file, serializer);
        }
        return MessageCollectors.toStream(System.out, serializer);
    }

    public <Message extends PMessage<Message, Field>, Field extends PField> Stream<Message> getInput() throws ParseException {
        PStructDescriptor<Message, Field> descriptor = this.getDefinition();
        Format fmt = Format.pretty;
        File file = null;
        if (this.in != null) {
            fmt = this.in.format != null ? this.in.format : fmt;
            file = this.in.file;
        }
        Serializer serializer = this.getSerializer(fmt);
        if (file != null) {
            try {
                return MessageStreams.file(file, serializer, descriptor);
            }
            catch (IOException e) {
                throw new ArgumentException("Unable to read file %s", file.getName());
            }
        }
        BufferedInputStream is = new BufferedInputStream(System.in);
        try {
            return MessageStreams.stream(is, serializer, descriptor);
        }
        catch (IOException e) {
            throw new ArgumentException("Broken pipe", new Object[0]);
        }
    }
}

