/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.converter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentParser;
import net.morimekta.providence.converter.ConvertOptions;
import net.morimekta.providence.converter.options.Format;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.util.Strings;

public class Convert {
    private final ConvertOptions options = new ConvertOptions();

    Convert() {
    }

    void run(String ... args) {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/build.properties"));
            ArgumentParser cli = this.options.getArgumentParser("pvd", "v" + properties.getProperty("build.version"), "Providence Converter");
            cli.parse(args);
            if (this.options.isHelp()) {
                System.out.println("Providence Converter - v" + properties.getProperty("build.version"));
                System.out.println("Usage: pvd [-i spec] [-o spec] [-I dir] [-S] type");
                System.out.println();
                System.out.println("Example code to run:");
                System.out.println("$ cat call.json | pvd -I thrift/ -s cal.Calculator");
                System.out.println("$ pvd -i binary,file:my.data -f json_protocol -I thrift/ -s cal.Calculator");
                System.out.println();
                cli.printUsage(System.out);
                System.out.println();
                System.out.println("Available formats are:");
                for (Format format : Format.values()) {
                    System.out.println(String.format(" - %-20s : %s", format.name(), format.desc));
                }
                return;
            }
            cli.validate();
            this.options.getInput().collect(this.options.getOutput());
            return;
        }
        catch (ArgumentException e) {
            System.err.println("Usage: pvd [-i spec] [-o spec] [-I dir] [-S] type");
            if (e.getLocalizedMessage().length() > 0) {
                System.err.println(e.getLocalizedMessage());
            } else {
                e.printStackTrace();
            }
            System.err.println();
            System.err.println("Run $ pvd --help # for available options.");
        }
        catch (ParseException e) {
            System.out.flush();
            System.err.println();
            if (e.getLine() != null) {
                int lineNo = e.getToken().getLineNo();
                int linePos = e.getToken().getLinePos();
                int len = e.getToken().length();
                System.err.format("Error at line %d, pos %d-%d: %s\n    %s\n    %s%c\n", lineNo, linePos, linePos + len, e.getLocalizedMessage(), e.getLine(), Strings.times("~", linePos), Character.valueOf('^'));
            } else {
                System.err.println("Parser error: " + e.getLocalizedMessage());
            }
        }
        catch (IOException | UncheckedIOException e) {
            System.out.flush();
            System.err.println();
            System.err.print("I/O error: ");
            e.printStackTrace();
        }
        this.exit(1);
    }

    protected void exit(int i) {
        System.exit(i);
    }

    public static void main(String[] args) throws Throwable {
        new Convert().run(args);
    }
}

