/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.chr;

import net.morimekta.console.chr.Char;

public class Unicode
implements Char {
    private final int cp;

    public Unicode(int cp) {
        this.cp = cp;
    }

    public Unicode(char ch) {
        this.cp = ch;
    }

    @Override
    public int asInteger() {
        return this.cp;
    }

    @Override
    public String asString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\'');
        switch (this.cp) {
            case 0: {
                return "<NUL>";
            }
            case 3: {
                return "<ABR>";
            }
            case 4: {
                return "<EOF>";
            }
            case 7: {
                return "<BEL>";
            }
            case 8: {
                return "<BS>";
            }
            case 11: {
                return "<VT>";
            }
            case 27: {
                return "<ESC>";
            }
            case 28: {
                return "<FS>";
            }
            case 29: {
                return "<GS>";
            }
            case 30: {
                return "<RS>";
            }
            case 31: {
                return "<US>";
            }
            case 127: {
                return "<DEL>";
            }
            case 9: {
                builder.append('\\').append('t');
                break;
            }
            case 10: {
                builder.append('\\').append('n');
                break;
            }
            case 12: {
                builder.append('\\').append('f');
                break;
            }
            case 13: {
                builder.append('\\').append('r');
                break;
            }
            case 34: 
            case 39: 
            case 92: {
                builder.append('\\').append((char)this.cp);
                break;
            }
            default: {
                if (this.cp < 32) {
                    builder.append(String.format("\\%03o", this.cp));
                    break;
                }
                if (127 < this.cp && this.cp < 160 || 8192 <= this.cp && this.cp < 8448 || !Character.isDefined(this.cp)) {
                    if (Character.isBmpCodePoint(this.cp)) {
                        builder.append(String.format("\\u%04x", this.cp));
                        break;
                    }
                    builder.append(String.format("\\u%04x", Character.highSurrogate(this.cp)));
                    builder.append(String.format("\\u%04x", Character.lowSurrogate(this.cp)));
                    break;
                }
                if (Character.isBmpCodePoint(this.cp)) {
                    builder.append((char)this.cp);
                    break;
                }
                builder.append(Character.highSurrogate(this.cp));
                builder.append(Character.lowSurrogate(this.cp));
            }
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public int printableWidth() {
        if (this.cp < 32 || 127 <= this.cp && this.cp < 160 || this.cp == 1564 || 8192 <= this.cp && this.cp <= 8448 || 65529 <= this.cp && this.cp <= 65531) {
            return 0;
        }
        if (12288 <= this.cp && this.cp < 12352 || 13056 <= this.cp && this.cp < 19904 || 19968 <= this.cp && this.cp < 65536 || 131072 <= this.cp && this.cp < 173760 || 173824 <= this.cp && this.cp < 183984) {
            return 2;
        }
        return 1;
    }

    @Override
    public int length() {
        if (!Character.isBmpCodePoint(this.cp)) {
            return 2;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Unicode)) {
            return false;
        }
        return this.asInteger() == ((Unicode)o).asInteger();
    }

    public String toString() {
        if (!Character.isBmpCodePoint(this.cp)) {
            return new String(new char[]{Character.highSurrogate(this.cp), Character.lowSurrogate(this.cp)});
        }
        return new String(new char[]{(char)this.cp});
    }

    public int hashCode() {
        return Integer.hashCode(this.cp);
    }

    public static Unicode makeBorder(int u, int r, int d, int l) {
        if (u < 0 || u > 3 || r < 0 || r > 3 || d < 0 || d > 3 || l < 0 || l > 3) {
            throw new IllegalArgumentException(String.format("No border possible for %d,%d,%d,%d.", u, r, d, l));
        }
        int id = u << 24 | r << 16 | d << 8 | l;
        switch (id) {
            case 1: {
                return new Unicode(9588);
            }
            case 4096: {
                return new Unicode(9589);
            }
            case 256: {
                return new Unicode(9590);
            }
            case 16: {
                return new Unicode(9591);
            }
            case 2: {
                return new Unicode(9592);
            }
            case 8192: {
                return new Unicode(9593);
            }
            case 512: {
                return new Unicode(9594);
            }
            case 32: {
                return new Unicode(9595);
            }
            case 257: {
                return new Unicode(9472);
            }
            case 514: {
                return new Unicode(9473);
            }
            case 4112: {
                return new Unicode(9474);
            }
            case 8224: {
                return new Unicode(9475);
            }
            case 513: {
                return new Unicode(9596);
            }
            case 4128: {
                return new Unicode(9597);
            }
            case 258: {
                return new Unicode(9598);
            }
            case 8208: {
                return new Unicode(9599);
            }
            case 272: {
                return new Unicode(9484);
            }
            case 528: {
                return new Unicode(9485);
            }
            case 288: {
                return new Unicode(9486);
            }
            case 544: {
                return new Unicode(9487);
            }
            case 17: {
                return new Unicode(9488);
            }
            case 18: {
                return new Unicode(9489);
            }
            case 33: {
                return new Unicode(9490);
            }
            case 34: {
                return new Unicode(9491);
            }
            case 4352: {
                return new Unicode(9492);
            }
            case 4608: {
                return new Unicode(9493);
            }
            case 8448: {
                return new Unicode(9494);
            }
            case 8704: {
                return new Unicode(9495);
            }
            case 4097: {
                return new Unicode(9496);
            }
            case 4098: {
                return new Unicode(9497);
            }
            case 8193: {
                return new Unicode(9498);
            }
            case 8194: {
                return new Unicode(9499);
            }
            case 4368: {
                return new Unicode(9500);
            }
            case 4624: {
                return new Unicode(9501);
            }
            case 8464: {
                return new Unicode(9502);
            }
            case 4384: {
                return new Unicode(9503);
            }
            case 8480: {
                return new Unicode(9504);
            }
            case 8720: {
                return new Unicode(9505);
            }
            case 4640: {
                return new Unicode(9506);
            }
            case 8736: {
                return new Unicode(9507);
            }
            case 4113: {
                return new Unicode(9492);
            }
            case 4114: {
                return new Unicode(9493);
            }
            case 4129: {
                return new Unicode(9494);
            }
            case 8209: {
                return new Unicode(9495);
            }
            case 8225: {
                return new Unicode(9512);
            }
            case 8210: {
                return new Unicode(9513);
            }
            case 4130: {
                return new Unicode(9514);
            }
            case 8226: {
                return new Unicode(9515);
            }
            case 273: {
                return new Unicode(9500);
            }
            case 274: {
                return new Unicode(9501);
            }
            case 529: {
                return new Unicode(9502);
            }
            case 530: {
                return new Unicode(9503);
            }
            case 289: {
                return new Unicode(9504);
            }
            case 290: {
                return new Unicode(9505);
            }
            case 545: {
                return new Unicode(9506);
            }
            case 546: {
                return new Unicode(9507);
            }
            case 4353: {
                return new Unicode(9508);
            }
            case 4354: {
                return new Unicode(9509);
            }
            case 4609: {
                return new Unicode(9510);
            }
            case 4610: {
                return new Unicode(9511);
            }
            case 8449: {
                return new Unicode(9512);
            }
            case 8450: {
                return new Unicode(9513);
            }
            case 8705: {
                return new Unicode(9514);
            }
            case 8706: {
                return new Unicode(9515);
            }
            case 4369: {
                return new Unicode(9532);
            }
            case 4370: {
                return new Unicode(9533);
            }
            case 4625: {
                return new Unicode(9534);
            }
            case 4626: {
                return new Unicode(9535);
            }
            case 8465: {
                return new Unicode(9536);
            }
            case 4385: {
                return new Unicode(9537);
            }
            case 8481: {
                return new Unicode(9538);
            }
            case 8466: {
                return new Unicode(9539);
            }
            case 8721: {
                return new Unicode(9540);
            }
            case 4386: {
                return new Unicode(9541);
            }
            case 4641: {
                return new Unicode(9542);
            }
            case 8722: {
                return new Unicode(9543);
            }
            case 4642: {
                return new Unicode(9544);
            }
            case 8482: {
                return new Unicode(9545);
            }
            case 8737: {
                return new Unicode(9546);
            }
            case 8738: {
                return new Unicode(9547);
            }
            case 771: {
                return new Unicode(9552);
            }
            case 12336: {
                return new Unicode(9553);
            }
            case 784: {
                return new Unicode(9554);
            }
            case 304: {
                return new Unicode(9555);
            }
            case 816: {
                return new Unicode(9556);
            }
            case 19: {
                return new Unicode(9557);
            }
            case 49: {
                return new Unicode(9558);
            }
            case 51: {
                return new Unicode(9559);
            }
            case 4864: {
                return new Unicode(9560);
            }
            case 12544: {
                return new Unicode(9561);
            }
            case 13056: {
                return new Unicode(9562);
            }
            case 4099: {
                return new Unicode(9563);
            }
            case 12289: {
                return new Unicode(9564);
            }
            case 12291: {
                return new Unicode(9565);
            }
            case 4880: {
                return new Unicode(9566);
            }
            case 12592: {
                return new Unicode(9567);
            }
            case 13104: {
                return new Unicode(9568);
            }
            case 4115: {
                return new Unicode(9569);
            }
            case 12337: {
                return new Unicode(9570);
            }
            case 12339: {
                return new Unicode(9571);
            }
            case 787: {
                return new Unicode(9572);
            }
            case 305: {
                return new Unicode(9573);
            }
            case 819: {
                return new Unicode(9574);
            }
            case 4867: {
                return new Unicode(9575);
            }
            case 12545: {
                return new Unicode(9576);
            }
            case 13059: {
                return new Unicode(9577);
            }
            case 4883: {
                return new Unicode(9578);
            }
            case 12593: {
                return new Unicode(9579);
            }
            case 13107: {
                return new Unicode(9580);
            }
        }
        throw new IllegalArgumentException(String.format("No border for (u:%d,r:%d,d:%d,l:%d).", u, r, d, l));
    }

    public static Unicode makeNumeric(int num) {
        if (num > 0) {
            if (num <= 20) {
                return new Unicode(9311 + num);
            }
            if (num <= 35) {
                return new Unicode(12860 + num);
            }
            if (num <= 50) {
                return new Unicode(12941 + num);
            }
        }
        throw new IllegalArgumentException("No circled numeric for " + num);
    }

    @Override
    public int compareTo(Char o) {
        return Integer.compare(this.asInteger(), o.asInteger());
    }
}

