/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.morimekta.console.args.ArgumentParser;

public class SubCommand<SubCommandDef> {
    private final String name;
    private final String usage;
    private final List<String> aliases;
    private final boolean hidden;
    private final Supplier<SubCommandDef> instanceFactory;
    private final Function<SubCommandDef, ArgumentParser> parserFactory;

    public SubCommand(String name, String usage, boolean hidden, Supplier<SubCommandDef> instanceFactory, Function<SubCommandDef, ArgumentParser> parserFactory, String ... aliases) {
        this(name, usage, hidden, instanceFactory, parserFactory, ImmutableList.copyOf(aliases));
    }

    public SubCommand(String name, String usage, boolean hidden, Supplier<SubCommandDef> instanceFactory, Function<SubCommandDef, ArgumentParser> parserFactory, Iterable<String> aliases) {
        this.name = name;
        this.usage = usage;
        this.instanceFactory = instanceFactory;
        this.parserFactory = parserFactory;
        this.hidden = hidden;
        this.aliases = ImmutableList.copyOf(aliases);
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public SubCommandDef newInstance() {
        return this.instanceFactory.get();
    }

    public ArgumentParser getArgumentParser(SubCommandDef instance) {
        return this.parserFactory.apply(instance);
    }
}

