/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.util.function.Consumer;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseOption;

public class Flag
extends BaseOption {
    public static final String NEGATE = "--no_";
    private final Consumer<Boolean> setter;
    private final String negateName;
    private boolean applied = false;

    public Flag(String name, String shortNames, String usage, Consumer<Boolean> setter) {
        this(name, shortNames, usage, setter, null);
    }

    public Flag(String name, String shortNames, String usage, Consumer<Boolean> setter, Boolean defaultValue) {
        this(name, shortNames, usage, setter, defaultValue, false);
    }

    public Flag(String name, String shortNames, String usage, Consumer<Boolean> setter, Boolean defaultValue, String negateName) {
        this(name, shortNames, usage, setter, defaultValue, negateName, false);
    }

    public Flag(String name, String shortNames, String usage, Consumer<Boolean> setter, Boolean defaultValue, boolean hidden) {
        this(name, shortNames, usage, setter, defaultValue, Flag.makeNegateName(name), hidden);
    }

    public Flag(String name, String shortNames, String usage, Consumer<Boolean> setter, Boolean defaultValue, String negateName, boolean hidden) {
        super(name, shortNames, null, usage, defaultValue == null ? null : defaultValue.toString(), false, false, hidden);
        this.setter = setter;
        this.negateName = negateName;
    }

    public String getNegateName() {
        return this.negateName;
    }

    @Override
    public String getSingleLineUsage() {
        if (this.getShortNames().length() > 0) {
            return null;
        }
        return super.getSingleLineUsage();
    }

    @Override
    public void validate() {
    }

    @Override
    public int applyShort(String opts, ArgumentList args) {
        if (this.applied) {
            throw new ArgumentException(this.nameOrShort() + " is already applied", new Object[0]);
        }
        this.applied = true;
        this.setter.accept(true);
        return 0;
    }

    @Override
    public int apply(ArgumentList args) {
        if (this.getName() == null) {
            throw new IllegalStateException("No long option for -[" + this.getShortNames() + "]");
        }
        if (this.applied) {
            throw new ArgumentException(this.nameOrShort() + " is already applied", new Object[0]);
        }
        this.applied = true;
        String current = args.get(0);
        if (current.equals(this.getName())) {
            this.setter.accept(true);
        } else if (current.equals(this.getNegateName())) {
            this.setter.accept(false);
        } else if (current.startsWith(this.getName() + "=")) {
            String value = current.substring(this.getName().length() + 1);
            this.setter.accept(Boolean.parseBoolean(value));
        } else {
            throw new IllegalArgumentException("Argument not matching flag " + this.nameOrShort() + ": " + current);
        }
        return 1;
    }

    private static String makeNegateName(String name) {
        if (name != null && name.startsWith("--")) {
            return NEGATE + name.substring(2);
        }
        return null;
    }
}

